/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CurProc;

public class Lib_Exec {
    public static void checkIsReturn(CurProc cp, ReturnException e) {
        Return temp = e.get();
        if (temp.getLevel() != Return.LEVEL.RETURN) {
            throw new ExecError(cp, "Wrong Return-Type", "Got " + (Object)((Object)temp.getLevel()));
        }
    }

    public static I_Object onePar(CurProc cp, I_Object itStream, int min, int max) {
        I_Object[] pars = cp.parsFlex(null, itStream, min, max);
        return pars.length == 0 ? Nil.NIL : pars[0];
    }

    public static I_Object execBlock(CurProc cpNew, BlockExecArgs args, I_Object it) {
        Call stream = cpNew.getStream();
        Block block = cpNew.getCallBlock();
        if (args.fixval) {
            it = args.par;
        }
        if (args.varlet) {
            Var o = ((VarLet)args.par).getVar();
            o.set(cpNew, cpNew, it);
        }
        if (block != null) {
            try {
                it = block.exec(cpNew, it);
            }
            catch (ReturnException e) {
                return e.get();
            }
        }
        if (stream != null) {
            it = stream.exec(cpNew, it);
        }
        return it;
    }

    public static void checkLoopWithout(CurProc cpOld, I_Object[] pars) {
        if (pars.length == 0 && cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            throw new CodeError(cpOld, "Wrong call", "No parameter, no stream, no block ... what should I do?");
        }
    }

    public static I_Object loopResult(I_Object result) {
        if (result instanceof Return && ((Return)result).getLevel() == Return.LEVEL.CONTINUE) {
            return ((Return)result).getResult();
        }
        return result;
    }
}

