/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Exec;

public abstract class A_IntNumber
extends A_Number
implements I_AutoBlockDo {
    @Override
    public final Result_Obj call4(CurProc cp, String method) {
        switch (method) {
            case "rangeTo": {
                return A_IntNumber.stdResult(this.range(cp));
            }
            case "toHex": {
                return A_IntNumber.stdResult(this.toHex(cp));
            }
            case "timesUp": 
            case "times": {
                return this.times(cp, false);
            }
            case "timesDown": {
                return this.times(cp, true);
            }
            case "isEven": {
                return A_IntNumber.stdResult(this.isEven(cp));
            }
            case "isOdd": {
                return A_IntNumber.stdResult(this.isOdd(cp));
            }
            case "isBetween": {
                return A_IntNumber.stdResult(this.isBetween(cp));
            }
            case "divisible": {
                return A_IntNumber.stdResult(this.divisible(cp));
            }
        }
        return this.call5(cp, method);
    }

    public abstract Result_Obj call5(CurProc var1, String var2);

    @Override
    public I_Object autoBlockDo(CurProc cp) {
        return this.times((CurProc)cp, (boolean)false).obj;
    }

    protected Result_Obj times(CurProc cpOld, boolean reverse) {
        I_Object[] pars = cpOld.parsBlockFlex(this, 0, 1);
        if (pars.length == 0 && cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            throw new CodeError(cpOld, "Wrong call", "No Parameter, no Stream, no Block, for times ... what to do?");
        }
        int value = ((Number)this.gValue()).intValue();
        int start = reverse ? value : 1;
        int end = reverse ? 0 : value + 1;
        int step = reverse ? -1 : 1;
        CurProc cpNew = cpOld.copyLoop(new Handle_Loop(this));
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = this;
        int i = start;
        while (i != end) {
            result = Lib_Exec.execBlock(cpNew, args, new Int(i));
            if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            i += step;
        }
        return new Result_Obj(result, true);
    }

    private I_Object toHex(CurProc cp) {
        cp.pars(Str.class);
        long value = ((Number)this.gValue()).longValue();
        String s = Long.toHexString(value);
        return new Str(s);
    }

    private Bool isEven(CurProc cp) {
        cp.pars(Bool.class);
        long value = ((Number)this.gValue()).longValue();
        return Bool.getObject(value % 2L == 0L);
    }

    private Bool isOdd(CurProc cp) {
        cp.pars(Bool.class);
        long value = ((Number)this.gValue()).longValue();
        return Bool.getObject(value % 2L != 0L);
    }

    private Bool isBetween(CurProc cp) {
        I_Object[] oa = cp.pars(Bool.class, this, A_IntNumber.class, A_IntNumber.class);
        long value = ((Number)this.gValue()).longValue();
        long i1 = ((Number)((A_IntNumber)oa[0]).gValue()).longValue();
        long i2 = ((Number)((A_IntNumber)oa[1]).gValue()).longValue();
        return Bool.getObject(value >= i1 && value <= i2);
    }

    private JMo_Range range(CurProc cp) {
        I_Object dest = cp.pars(JMo_Range.class, this, A_Number.class)[0];
        return JMo_Range.createNew(cp, this, dest);
    }

    private JMo_List divisible(CurProc cp) {
        cp.pars(JMo_List.class, this, new Class[0]);
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        boolean isLong = this.gValue() instanceof Long;
        if (isLong) {
            long value = ((Number)this.gValue()).longValue();
            long i = Math.abs(value);
            int fi = 1;
            while ((long)fi <= i / 2L) {
                if ((double)i / (double)fi == (double)(i / (long)fi)) {
                    list.add(new JMo_Long(fi));
                }
                ++fi;
            }
            if (i != 0L) {
                list.add(new JMo_Long(i));
            }
            return new JMo_List(list);
        }
        int iv = ((Number)this.gValue()).intValue();
        int i = Math.abs(iv);
        int fi = 1;
        while (fi <= i / 2) {
            if ((double)i / (double)fi == (double)(i / fi)) {
                list.add(new Int(fi));
            }
            ++fi;
        }
        if (i != 0) {
            list.add(new Int(i));
        }
        return new JMo_List(list);
    }
}

