/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.constant.position;

import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.constant.position.POSITION_V;
import de.mn77.base.error.Err;

public class Lib_Position {
    public static boolean isLeft(POSITION p) {
        return p == POSITION.LEFT || p == POSITION.TOP_LEFT || p == POSITION.BOTTOM_LEFT;
    }

    public static boolean isRight(POSITION p) {
        return p == POSITION.RIGHT || p == POSITION.TOP_RIGHT || p == POSITION.BOTTOM_RIGHT;
    }

    public static boolean isTop(POSITION p) {
        return p == POSITION.TOP || p == POSITION.TOP_LEFT || p == POSITION.TOP_RIGHT;
    }

    public static boolean isBottom(POSITION p) {
        return p == POSITION.BOTTOM || p == POSITION.BOTTOM_LEFT || p == POSITION.BOTTOM_RIGHT;
    }

    public static boolean isHCenter(POSITION p) {
        return p == POSITION.TOP || p == POSITION.CENTER || p == POSITION.BOTTOM;
    }

    public static boolean isVCenter(POSITION p) {
        return p == POSITION.LEFT || p == POSITION.CENTER || p == POSITION.RIGHT;
    }

    public static <T> T selectH(POSITION_H ph, T ifLeft, T ifCenter, T ifRight) {
        if (ph == POSITION_H.LEFT) {
            return ifLeft;
        }
        if (ph == POSITION_H.CENTER) {
            return ifCenter;
        }
        if (ph == POSITION_H.RIGHT) {
            return ifRight;
        }
        throw Err.impossible(ph);
    }

    public static <T> T selectV(POSITION_V pv, T ifTop, T ifCenter, T ifBottom) {
        if (pv == POSITION_V.TOP) {
            return ifTop;
        }
        if (pv == POSITION_V.CENTER) {
            return ifCenter;
        }
        if (pv == POSITION_V.BOTTOM) {
            return ifBottom;
        }
        throw Err.impossible(pv);
    }

    public static POSITION_H getHorizontal(POSITION p) {
        if (Lib_Position.isLeft(p)) {
            return POSITION_H.LEFT;
        }
        if (Lib_Position.isHCenter(p)) {
            return POSITION_H.CENTER;
        }
        if (Lib_Position.isRight(p)) {
            return POSITION_H.RIGHT;
        }
        return null;
    }

    public static POSITION_V getVertical(POSITION p) {
        if (Lib_Position.isTop(p)) {
            return POSITION_V.TOP;
        }
        if (Lib_Position.isVCenter(p)) {
            return POSITION_V.CENTER;
        }
        if (Lib_Position.isBottom(p)) {
            return POSITION_V.BOTTOM;
        }
        return null;
    }
}

