/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Table;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.MC_THIS;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.ATOMIC;

public class Lib_Convert {
    public static boolean getBoolValue(CurProc cp, I_Object o) {
        if ((o = Lib_Convert.getValue(cp, o)) instanceof Bool) {
            return ((Bool)o).gValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Boolean)((I_AtomicValue)o).convertTo(cp, ATOMIC.BOOL).gValue();
        }
        throw new ExecError(cp, "Wrong type", o.toDebug(cp));
    }

    public static char getCharValue(CurProc cp, I_Object o) {
        if ((o = Lib_Convert.getValue(cp, o)) instanceof Char) {
            return ((Char)o).gValue().charValue();
        }
        if (o instanceof I_AtomicValue) {
            return ((Character)((I_AtomicValue)o).convertTo(cp, ATOMIC.CHAR).gValue()).charValue();
        }
        throw new ExecError(cp, "Wrong type", o.toDebug(cp));
    }

    public static double getDoubleValue(CurProc cp, I_Object o) {
        if ((o = Lib_Convert.getValue(cp, o)) instanceof Dec) {
            return ((Dec)o).gValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Double)((I_AtomicValue)o).convertTo(cp, ATOMIC.DEC).gValue();
        }
        throw new ExecError(cp, "Wrong type", o.toDebug(cp));
    }

    public static int getIntValue(CurProc cp, I_Object o) {
        if ((o = Lib_Convert.getValue(cp, o)) instanceof Int) {
            return ((Int)o).gValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Integer)((I_AtomicValue)o).convertTo(cp, ATOMIC.INT).gValue();
        }
        throw new ExecError(cp, "Wrong type", o.toDebug(cp));
    }

    public static long getLongValue(CurProc cp, I_Object o) {
        if ((o = Lib_Convert.getValue(cp, o)) instanceof JMo_Long) {
            return ((JMo_Long)o).gValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Long)((I_AtomicValue)o).convertTo(cp, ATOMIC.LONG).gValue();
        }
        throw new ExecError(cp, "Wrong type", o.toDebug(cp));
    }

    public static String getStringValue(CurProc cp, I_Object o) {
        if ((o = Lib_Convert.getValue(cp, o)) instanceof Str) {
            return ((Str)o).gValue();
        }
        if (o instanceof I_AtomicValue) {
            return "" + ((I_AtomicValue)o).convertTo(cp, ATOMIC.STR).gValue();
        }
        return o.toString();
    }

    public static I_Object getValue(CurProc cp, I_Object o) {
        Err.ifNull(o);
        if (o instanceof Var) {
            return ((Var)o).get(cp);
        }
        if (o instanceof Const) {
            return ((Const)o).get(cp);
        }
        return o;
    }

    public static JMo_List toJMo(I_Sequence<String> list) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        for (String s : list) {
            al.add(new Str(s));
        }
        return new JMo_List(al);
    }

    public static JMo_Table toJMo(I_Table<String> tab) {
        MTable<I_Object> jt = new MTable<I_Object>(tab.getWidth());
        for (I_Sequence i_Sequence : tab) {
            jt.add((I_Sequence<I_Object>)new MList<I_Object>((Collection<I_Object>)Lib_Convert.toJMo(i_Sequence).getInternalObject()));
        }
        return new JMo_Table(jt);
    }

    public static I_List<String> toListString(I_Sequence<I_Object> list) {
        MList<String> res = new MList<String>();
        for (I_Object s : list) {
            res.add(Lib_Convert.getStringValue(null, s));
        }
        return res;
    }

    public static String toString(Call c) {
        if (c == null) {
            return Nil.NIL.toString();
        }
        return c.toString();
    }

    public static I_Table<String> toTabString(JMo_Table tab) {
        MTable<String> res = new MTable<String>(tab.getInternalObject().getWidth());
        for (I_Sequence i_Sequence : tab.getInternalObject()) {
            res.add((I_Sequence<String>)Lib_Convert.toListString(i_Sequence));
        }
        return res;
    }

    public static String typelistToText(Class<?>[] types) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int pos = 0;
        while (pos < types.length) {
            Class<?> c = types[pos];
            if (pos != 0) {
                sb.append(", ");
            }
            sb.append(Lib_Convert.typeName(c, null));
            ++pos;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String typeName(Class<?> objClass, I_Object obj) {
        Err.ifNull(objClass);
        String s = objClass.getSimpleName();
        if (objClass == MC_THIS.class) {
            Err.ifNull(obj);
            s = ((MC_THIS)obj).get().getName();
        }
        if (objClass == Instance.class) {
            Err.ifNull(obj);
            s = ((Instance)obj).getType().getName();
        }
        if (objClass == Var.class) {
            Err.ifNull(obj);
            s = "Var";
        }
        if (objClass == Const.class) {
            Err.ifNull(obj);
            s = ((Const)obj).getTypeName();
        }
        s = s.replaceFirst("^.*\\.", "");
        s = s.replaceFirst("^JMo_", "");
        s = s.replaceFirst("^A_", "");
        return s;
    }
}

