/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;

public class ParCallBuffer {
    private Call call;
    private I_Object obj = null;
    private boolean init = false;
    private Class<? extends I_Object>[] typecheck = null;

    public ParCallBuffer(Call c) {
        Err.ifNull(c);
        this.call = c;
    }

    public I_Object init(CurProc cp, I_Object streamIt, Class<? extends I_Object> type) {
        this.obj = cp.parType(this.call.exec(cp, streamIt), type);
        this.typecheck = new Class[]{type};
        this.init = true;
        return this.obj;
    }

    @SafeVarargs
    public final I_Object initExt(CurProc cp, I_Object streamIt, Class<? extends I_Object> ... types) {
        this.obj = cp.parTypeExt(this.call.exec(cp, streamIt), types);
        this.typecheck = types;
        this.init = true;
        return this.obj;
    }

    public I_Object get() {
        if (!this.init) {
            Err.invalid("ParCallBuffer not initialized!", this.call);
        }
        return this.obj;
    }

    public I_Object getNew(CurProc cp) {
        if (!this.init) {
            Err.invalid("ParCallBuffer not initialized!", this.call);
        }
        this.obj = cp.parTypeExt(this.call.exec(cp, null), this.typecheck);
        return this.obj;
    }

    public void replace(Call c) {
        this.call = c;
    }

    public void describe(CurProc cp, int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + this.call.toDebug(cp));
    }

    public String toDebug(CurProc cp) {
        return Lib_Output.toDebug(cp, this.call);
    }

    public String toString() {
        return this.obj != null ? Lib_Output.toString(this.obj, true) : Lib_Output.toString(this.call, false);
    }
}

