/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Java;

public class JMo_Java
extends A_Object {
    private String className;
    private final ParCallBuffer classNameCall;
    private final ParCallBuffer constructorPar;
    private Object instance = null;
    private Class<?> instance_class = null;

    public JMo_Java(Call classNameCall, Call[] pars, DebugInfo debugInfo) {
        this.className = null;
        this.classNameCall = new ParCallBuffer(classNameCall);
        if (pars == null || pars.length == 0) {
            this.constructorPar = null;
        } else {
            if (pars.length > 1) {
                throw new CodeError("Wrong Parameter-Structure for construtor", "Want constructor-aruments within a list.", debugInfo);
            }
            this.constructorPar = new ParCallBuffer(pars[0]);
        }
    }

    public JMo_Java(String name, Call[] pars, DebugInfo debugInfo) {
        this.className = name;
        this.classNameCall = null;
        if (pars == null) {
            this.constructorPar = null;
        } else {
            if (pars.length != 1) {
                throw new CodeError("Wrong Parameter-Structure for construtor", "Want Parameters in a list.", debugInfo);
            }
            this.constructorPar = new ParCallBuffer(pars[0]);
        }
    }

    @Override
    public void init(CurProc cp) {
        if (this.classNameCall != null) {
            this.classNameCall.init(cp, this, Str.class);
        }
        if (this.constructorPar != null) {
            this.constructorPar.init(cp, this, JMo_List.class);
        }
        if (this.className == null && this.classNameCall != null) {
            I_Object oName = this.classNameCall.get();
            this.className = Lib_Convert.getStringValue(cp, oName);
        }
        if (this.className.startsWith("JMo_")) {
            throw new ExecError(cp, "It's not allowed to create JMo-Objects via Java-Class!", this.className);
        }
        this.instance_class = this.searchClass(cp);
        this.instance = this.getInstance(cp, this.instance_class);
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        Method[] methods;
        I_Object[] pars = cp.parsFlex(null, (Boolean)false, 0, Integer.MAX_VALUE);
        int parsLen = pars.length;
        String m = cp.getMethod();
        if (m.equals("field")) {
            String field = Lib_Convert.getStringValue(cp, cp.pars(this, Str.class)[0]);
            try {
                Field f = this.instance_class.getField(field);
                Object value = f.get(this.instance);
                I_Object jmoValue = Lib_Java.javaToJmo(value);
                return JMo_Java.stdResult(jmoValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new ExecError(cp, "Unknown field or illegal access", field);
            }
        }
        Method[] methodArray = methods = this.instance_class.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(m) && method.getParameterCount() == parsLen && this.iTestPars(method.getParameters(), pars)) {
                Object[] invokePars = this.iJMoToJava(pars);
                try {
                    Object result = method.invoke(this.instance, invokePars);
                    I_Object resultJMo = Lib_Java.javaToJmo(result);
                    return JMo_Java.stdResult(resultJMo);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Err.show(e, true);
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String toDebug(CurProc cp) {
        return this.toString();
    }

    @Override
    public String toString() {
        String pars = "";
        if (this.constructorPar != null) {
            pars = ", " + this.constructorPar.toString();
        }
        return "Java(\"" + this.className + "\"" + pars + ")";
    }

    private Object getInstance(CurProc cp, Class<?> cl) {
        JMo_List parList;
        if (this.constructorPar == null || ((JMo_List)this.constructorPar.get()).getInternalObject().size() == 0) {
            try {
                return cl.newInstance();
            }
            catch (InstantiationException e) {
                Err.show(e, true);
            }
            catch (IllegalAccessException e) {
                String message = e.getMessage().replace("Class " + JMo_Java.class.getName(), "You");
                throw new ExecError(cp, "Illegal Access", message);
            }
        }
        if (!((parList = (JMo_List)this.constructorPar.get()) instanceof JMo_List)) {
            throw new ExecError(cp, "Wrong parameters for construtor", "Want constructor-aruments within a list.");
        }
        ArrayList<I_Object> pars = parList.getInternalObject();
        Object[] javaPars = this.iJMoToJava(pars.toArray(new I_Object[pars.size()]));
        Class<?>[] javaParTypes = this.iJavaTypes(javaPars);
        try {
            Constructor<?> ca = cl.getConstructor(javaParTypes);
            return ca.newInstance(javaPars);
        }
        catch (NoSuchMethodException e) {
            throw new ExecError(cp, "Wrong parameters for constructor", this.className);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            Err.show(e, true);
            throw Err.invalid(this.className, javaParTypes);
        }
    }

    private Class<?>[] iJavaTypes(Object[] javaPars) {
        Class[] javaParTypes = new Class[javaPars.length];
        int i = 0;
        while (i < javaPars.length) {
            javaParTypes[i] = Lib_Java.toJavaType(javaPars[i]);
            ++i;
        }
        return javaParTypes;
    }

    private Object[] iJMoToJava(I_Object[] pars) {
        int len = pars.length;
        Object[] result = new Object[len];
        int p = 0;
        while (p < len) {
            result[p] = Lib_Java.jmoToJava(pars[p]);
            ++p;
        }
        return result;
    }

    private boolean iTestPar(Parameter parameter, I_Object object) {
        Class<?> pClass = parameter.getType();
        int parModif = parameter.getModifiers();
        Class<?> oClass = object.getClass();
        if (parModif != 0) {
            Err.todo(pClass, parModif, oClass);
        }
        return Lib_Java.comparable(pClass, oClass);
    }

    private boolean iTestPars(Parameter[] parameters, I_Object[] pars) {
        if (parameters.length != pars.length) {
            return false;
        }
        int pn = 0;
        while (pn < parameters.length) {
            if (!this.iTestPar(parameters[pn], pars[pn])) {
                return false;
            }
            ++pn;
        }
        return true;
    }

    private Class<?> searchClass(CurProc cp) {
        char c1 = this.className.charAt(0);
        Class<I_Object> result = null;
        if (c1 >= 'a' && c1 <= 'z') {
            try {
                result = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new ExecError(cp, "Java-Class not found!", this.className);
            }
        } else {
            Package[] packages;
            Package[] packageArray = packages = Package.getPackages();
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                Package p = packageArray[n2];
                String test = String.valueOf(p.getName()) + "." + this.className;
                try {
                    result = Class.forName(test);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ++n2;
                }
            }
        }
        if (result == null) {
            throw new ExecError(cp, "Java-Class not found!", this.className);
        }
        if (result.isAssignableFrom(I_Object.class)) {
            throw new ExecError(cp, "It's not allowed to create JMo-Objects via Java-Class!", this.className);
        }
        return result;
    }
}

