/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.object.I_JMoDebug;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.pseudo.I_ObjToReplace;
import org.jmo_lang.object.pseudo.MC_BLOCK;
import org.jmo_lang.object.pseudo.MC_EACH;
import org.jmo_lang.object.pseudo.MC_STREAM;
import org.jmo_lang.object.pseudo.MagicConst;
import org.jmo_lang.object.pseudo.MultiCall;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.hints.HintManager;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;

public class Call
implements I_JMoDebug {
    private final DebugInfo debugInfo;
    private final I_Object obj;
    private final String met;
    private final Call[] par_calls;
    private final Block surrounding;
    private Block ownBlock = null;
    private Call stream = null;
    private Call lastCall = null;

    public Call(Block surrBlock, I_Object obj, DebugInfo debugInfo) {
        this(surrBlock, obj, null, null, debugInfo);
    }

    public Call(Block surrBlock, I_Object obj, String met, Call[] pars, DebugInfo debugInfo) {
        if (met != null && met.length() == 0) {
            Err.invalid(met);
        }
        Err.ifNull(surrBlock);
        this.surrounding = surrBlock;
        this.obj = obj;
        this.met = met;
        this.par_calls = pars;
        this.debugInfo = debugInfo;
    }

    public void describe(CurProc cp, int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + this.toDebug(cp));
        if (cp.parResultIsSet()) {
            I_Object[] i_ObjectArray = cp.parResultGet(this);
            int n = i_ObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object par = i_ObjectArray[n2];
                par.describe(cp, left + 1);
                ++n2;
            }
        }
        if (this.ownBlock != null) {
            this.ownBlock.describe(cp, left + 1);
        }
    }

    public final I_Object exec(CurProc cp, I_Object streamIt) {
        return this.exec(cp, streamIt, null);
    }

    public final I_Object exec(CurProc cpOld, I_Object streamIt, I_Object eachIt) {
        I_Object with;
        I_Object res = null;
        I_Object objNew = this.obj;
        CurProc cpNew = cpOld.copyCall(this, false);
        I_Object i_Object = with = objNew != null ? objNew : streamIt;
        if (with instanceof I_ObjToReplace) {
            if (with instanceof MC_BLOCK) {
                with = this.surrounding.gIT();
            }
            if (objNew instanceof MC_STREAM) {
                with = streamIt;
            }
            if (with instanceof MC_EACH) {
                if (eachIt == null) {
                    throw new CodeError(cpOld, "Invalid call!", "This function currently doesn't support _EACH.");
                }
                with = eachIt;
            }
            if (with instanceof MagicConst) {
                with = ((MagicConst)with).get(cpNew);
            }
        }
        if (with == null) {
            throw new CodeError(cpOld, "Missing Object, nothing to work with", "Invalid use of MagicConst: " + this.getInternObject().toDebug(cpOld));
        }
        if (with != null) {
            if (with instanceof NonAtomic) {
                with = ((NonAtomic)with).create(cpNew);
            }
            with.init(cpNew);
        }
        boolean multicall = false;
        if (this.par_calls != null) {
            Call[] callArray = this.par_calls;
            int n = this.par_calls.length;
            int n2 = 0;
            while (n2 < n) {
                Call c = callArray[n2];
                if (c.obj instanceof MultiCall) {
                    multicall = true;
                    break;
                }
                ++n2;
            }
        }
        if (!multicall) {
            res = with.call(cpNew);
        } else {
            Call[] pars = this.par_calls;
            int plen = pars.length;
            I_Object o = this.obj != null ? this.obj : with;
            I_Object[] parsResult = new I_Object[plen];
            int pp = 0;
            while (pp < pars.length) {
                parsResult[pp] = pars[pp].exec(cpNew, o);
                ++pp;
            }
            res = this.iExecMultiCall(cpNew, with, 0, parsResult);
        }
        if (cpOld.getApp().genHints) {
            HintManager hints = cpOld.getApp().gHintManager();
            if (objNew == null) {
                MOut.text("Object is null: " + this.met);
            } else if (this.met != null && objNew.getClass() != Instance.class) {
                hints.addType(objNew.getTypeName(), objNew.getTypes());
                if (!this.getSurrounding().gType().getFunctions().knows(this.met)) {
                    hints.addCall(cpOld, res.getTypeName(), this.met, cpOld.parResultGet(this));
                }
            }
        }
        return res;
    }

    private I_Object iExecMultiCall(CurProc cp, I_Object with, int ppos, I_Object[] current) {
        int len = current.length;
        if (ppos == len) {
            CurProc cpNew2 = cp.copyCall(this, false);
            cpNew2.parResultSet(this, current, false);
            return with.call(cpNew2);
        }
        I_Object[] current2 = new I_Object[len];
        System.arraycopy(current, 0, current2, 0, len);
        if (current[ppos] instanceof MultiCall) {
            I_Object result = with;
            MultiCall curMC = (MultiCall)current[ppos];
            curMC.exec(cp, cp.getSurrBlock(), with);
            curMC.reset();
            while (curMC.hasNext()) {
                current2[ppos] = curMC.getNext();
                result = this.iExecMultiCall(cp, with, ppos + 1, current2);
            }
            return result;
        }
        return this.iExecMultiCall(cp, with, ppos + 1, current2);
    }

    public I_Object execStream(CurProc cp, I_Object streamIt) {
        CurProc cpNew = cp.copyCall(cp.call, false);
        I_Object result = this.stream.exec(cpNew, streamIt);
        cp.parResultSet(this, new I_Object[]{result}, true);
        return result;
    }

    public Block getCallBlock() {
        return this.ownBlock;
    }

    public DebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    public I_Object getInternObject() {
        return this.obj;
    }

    public Call[] getInternPars() {
        return this.par_calls;
    }

    public Call getLastParCall() {
        return this.lastCall;
    }

    public String getMethod() {
        return this.met;
    }

    public I_Object[] getPars(CurProc cp, I_Object streamIt, I_Object eachIt) {
        if (!cp.parResultIsSet()) {
            int len = this.par_calls == null ? 0 : this.par_calls.length;
            I_Object[] parsTemp = new I_Object[len];
            if (len > 0) {
                int pp = 0;
                while (pp < len) {
                    I_Object o = this.obj != null ? this.obj : streamIt;
                    parsTemp[pp] = this.par_calls[pp].exec(cp, o, eachIt);
                    ++pp;
                }
            }
            if (!cp.parResultIsSet()) {
                cp.parResultSet(this, parsTemp, false);
            }
        }
        return cp.parResultGet(this);
    }

    public Call getStream() {
        return this.stream;
    }

    public Block getSurrounding() {
        return this.surrounding;
    }

    public void setBlock(Block b) {
        if (this.ownBlock != null) {
            Err.invalid(this.ownBlock, b);
        }
        this.ownBlock = b;
    }

    public void setLastCall(Call c) {
        this.lastCall = c;
    }

    public void setStream(Call c) {
        if (this.stream != null || c == null) {
            Err.invalid(this.stream, c);
        }
        this.stream = c;
    }

    @Override
    public String toDebug(CurProc cp) {
        return this.iToDebug(cp, false, false);
    }

    @Override
    public String toString() {
        String o = this.obj == null ? "" : (this.obj instanceof I_AtomicValue ? this.obj.toDebug(null) : this.obj.toString());
        String a = this.met != null || this.ownBlock != null || this.stream != null ? "\u2026" : "";
        return String.valueOf(o) + a;
    }

    private String iToDebug(CurProc cp, boolean withStream, boolean full) {
        String s;
        String o = this.obj == null ? "" : this.obj.toDebug(cp);
        String m = this.met == null ? "" : "." + this.met;
        String p = Lib_Output.toDebug(cp, this.par_calls);
        if (p.length() != 0) {
            p = "(" + p + ")";
        }
        String b = this.ownBlock == null ? "" : "{" + this.ownBlock.toDebug(cp) + "}";
        String string = s = this.stream == null ? "" : this.stream.toDebug(cp);
        if (this.met == null && this.ownBlock == null && this.stream == null) {
            return String.valueOf(o) + p;
        }
        return withStream ? String.valueOf(o) + m + p + b + s : String.valueOf(o) + m + p + b;
    }
}

