/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.version.I_VersionData;
import de.mn77.base.version.Lib_Version;
import org.jmo_lang.JMo;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.struct.App;

public class Parser_App {
    public Parser_App() {
        this.versionUpdate();
    }

    public I_VersionData getVersion() {
        return JMo.VERSION;
    }

    public String getVersionString(boolean withBuild, boolean withDate) {
        String format = "%1.%2.%3" + (withBuild ? " (%b)" : "") + (withDate ? " - %dd.mm.yyyy" : "");
        return JMo.VERSION.toFormat(format);
    }

    public App parseFile(App app, I_File datei) throws Err_FileSys {
        String source = Lib_TextFile.read(datei.getFile(), true);
        return this.parseText(app, datei.getName(), source);
    }

    public App parseFile(I_File datei) throws Err_FileSys {
        App app = new App();
        return this.parseFile(app, datei);
    }

    public App parseText(App app, String filename, String source) throws Err_FileSys {
        Parser_Script.parse(app, filename, source);
        while (app.importsHasToParse()) {
            I_File datei = app.importsNext();
            String s = Lib_TextFile.read(datei.getFile(), true);
            Parser_Script.parse(app, datei.getName(), s);
        }
        return app;
    }

    public App parseText(String source) throws Err_FileSys {
        App app = new App();
        return this.parseText(app, "", source);
    }

    private void versionUpdate() {
        try {
            Lib_Version.init(JMo.VERSION, false);
        }
        catch (Err_FileSys e) {
            Err.show(e, false);
        }
    }
}

