/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.Sys;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.JMo_Path;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_FileList
extends A_Object {
    private final Call files;

    public JMo_FileList(Call files) {
        this.files = files;
    }

    @Override
    public void init(CurProc cp) {
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "do": 
            case "each": {
                return this.each(cp, false);
            }
            case "toList": {
                return this.each(cp, true);
            }
        }
        return null;
    }

    @Override
    public void describe(CurProc cp, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cp));
    }

    @Override
    public String toDebug(CurProc cp) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "<" + this.files + ">";
    }

    private Result_Obj each(CurProc cp, boolean toList) {
        if (toList) {
            cp.parsFlex((I_Object)this, null, new Class[0]);
        } else {
            cp.pars();
        }
        DirectoryStream<Path> inhalt = this.searchFiles(cp.copyCall(this.files, false));
        Call stream = cp.getStream();
        Block block = cp.getCallBlock();
        if (stream == null && block == null) {
            Err.impossible("Mit was bittesch\u00f6n? Alles null!");
        }
        I_Object res = this;
        ArrayList<I_Object> list = toList ? new ArrayList<I_Object>() : null;
        block5: for (Path d : inhalt) {
            JMo_Path it = new JMo_Path(new Call(cp.getSurrBlock(), new Str(d.toString()), cp.getDebugInfo()));
            it.init(cp);
            if (toList) {
                list.add(it);
                continue;
            }
            if (block != null) {
                try {
                    res = block.exec(cp, it);
                }
                catch (ReturnException e) {
                    Return temp = (Return)res;
                    switch (temp.getLevel()) {
                        case CONTINUE: {
                            continue block5;
                        }
                        default: {
                            return temp.getLoopResult();
                        }
                    }
                }
            }
            if (stream == null) continue;
            res = stream.exec(cp, it);
        }
        return toList ? new Result_Obj(new JMo_List(list), false) : new Result_Obj(res, true);
    }

    private DirectoryStream<Path> searchFiles(CurProc cp) {
        I_Object o = this.files.exec(cp, null);
        if (!(o instanceof Str)) {
            Err.invalid(o);
        }
        String s = ((Str)o).gValue();
        String regex = "(.*)" + Sys.getSeperatorDir() + "(.*)";
        String path = s.replaceFirst(regex, "$1");
        String search = s.replaceFirst(regex, "$2");
        try {
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(path, new String[0]), search);
            return dirStream;
        }
        catch (IOException e) {
            throw Err.show(e, true);
        }
    }
}

