/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.datetime;

import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.datetime.JMo_Date;
import org.jmo_lang.object.datetime.JMo_Time;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_DateTime
extends A_Object {
    private MDateTime datetime;
    private final Call[] init;

    public JMo_DateTime() {
        this.init = null;
    }

    public JMo_DateTime(Call str) {
        this.init = new Call[]{str};
    }

    public JMo_DateTime(Call y, Call m, Call d, Call hh, Call mm, Call ss) {
        this.init = new Call[]{y, m, d, hh, mm, ss};
    }

    @Override
    public void init(CurProc cp) {
        if (this.init == null) {
            this.datetime = new MDateTime();
        } else if (this.init.length == 1) {
            String s = Lib_Convert.getStringValue(cp, this.init[0].exec(cp, null));
            this.datetime = new MDateTime(s);
        } else {
            int iy = Lib_Convert.getIntValue(cp, this.init[0].exec(cp, null));
            int im = Lib_Convert.getIntValue(cp, this.init[1].exec(cp, null));
            int id = Lib_Convert.getIntValue(cp, this.init[2].exec(cp, null));
            int ihh = Lib_Convert.getIntValue(cp, this.init[3].exec(cp, null));
            int imm = Lib_Convert.getIntValue(cp, this.init[4].exec(cp, null));
            int iss = Lib_Convert.getIntValue(cp, this.init[5].exec(cp, null));
            this.datetime = new MDateTime(iy, im, id, ihh, imm, iss);
        }
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "year": {
                return JMo_DateTime.stdResult(this.getYear(cp));
            }
            case "month": {
                return JMo_DateTime.stdResult(this.getMonth(cp));
            }
            case "day": {
                return JMo_DateTime.stdResult(this.getDay(cp));
            }
            case "hour": 
            case "hours": {
                return JMo_DateTime.stdResult(this.getHours(cp));
            }
            case "min": 
            case "minutes": {
                return JMo_DateTime.stdResult(this.getMinutes(cp));
            }
            case "sec": 
            case "seconds": {
                return JMo_DateTime.stdResult(this.getSeconds(cp));
            }
            case "toStr": {
                return JMo_DateTime.stdResult(this.toStr(cp));
            }
            case "format": {
                return JMo_DateTime.stdResult(this.format(cp));
            }
            case "date": {
                return JMo_DateTime.stdResult(this.getDate(cp));
            }
            case "time": {
                return JMo_DateTime.stdResult(this.getTime(cp));
            }
            case "diffDays": {
                return JMo_DateTime.stdResult(this.diffDays(cp));
            }
            case "diffHours": {
                return JMo_DateTime.stdResult(this.diffHours(cp));
            }
            case "diffMinutes": {
                return JMo_DateTime.stdResult(this.diffMinutes(cp));
            }
            case "diffSeconds": {
                return JMo_DateTime.stdResult(this.diffSeconds(cp));
            }
            case "==": 
            case "equal": {
                return JMo_DateTime.stdResult(this.compare(cp, COMPARE.E));
            }
            case "!=": 
            case "differs": {
                return JMo_DateTime.stdResult(this.compare(cp, COMPARE.NE));
            }
            case ">": 
            case "greater": {
                return JMo_DateTime.stdResult(this.compare(cp, COMPARE.G));
            }
            case "lesser": 
            case "<": {
                return JMo_DateTime.stdResult(this.compare(cp, COMPARE.L));
            }
            case ">=": 
            case "greaterOrEqual": {
                return JMo_DateTime.stdResult(this.compare(cp, COMPARE.GE));
            }
            case "<=": 
            case "lesserOrEqual": {
                return JMo_DateTime.stdResult(this.compare(cp, COMPARE.LE));
            }
        }
        return null;
    }

    @Override
    public void describe(CurProc cp, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cp));
    }

    @Override
    public String toDebug(CurProc cp) {
        if (this.datetime == null) {
            return "DateTime";
        }
        return "DateTime(" + this.toString() + ")";
    }

    @Override
    public String toString() {
        if (this.datetime == null) {
            return "DateTime";
        }
        return this.datetime.toString();
    }

    private Bool compare(CurProc cp, COMPARE co) {
        JMo_DateTime d = (JMo_DateTime)cp.pars(this, JMo_DateTime.class)[0];
        boolean isEqual = this.datetime.isEqual(d.getInternalValue());
        boolean isGreater = this.datetime.isGreater(d.getInternalValue());
        boolean result = false;
        switch (co) {
            case E: {
                result = isEqual;
                break;
            }
            case NE: {
                result = !isEqual;
                break;
            }
            case L: {
                result = !isEqual && !isGreater;
                break;
            }
            case LE: {
                result = isEqual || !isGreater;
                break;
            }
            case G: {
                result = isGreater;
                break;
            }
            case GE: {
                result = isEqual || isGreater;
            }
        }
        return Bool.getObject(result);
    }

    private Int diffDays(CurProc cp) {
        JMo_DateTime par = (JMo_DateTime)cp.pars(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffDays(par.getInternalValue());
        return new Int(diff);
    }

    private Int diffSeconds(CurProc cp) {
        JMo_DateTime par = (JMo_DateTime)cp.pars(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffSeconds(par.getInternalValue());
        return new Int(diff);
    }

    private Int diffMinutes(CurProc cp) {
        JMo_DateTime par = (JMo_DateTime)cp.pars(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffMinutes(par.getInternalValue());
        return new Int(diff);
    }

    private Int diffHours(CurProc cp) {
        JMo_DateTime par = (JMo_DateTime)cp.pars(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffHours(par.getInternalValue());
        return new Int(diff);
    }

    private I_Object format(CurProc cp) {
        String s = ((Str)cp.pars(this, Str.class)[0]).gValue();
        StringBuilder sb = new StringBuilder();
        while (s.length() > 0) {
            int move = 0;
            if (s.startsWith("YYYY")) {
                sb.append(FormNumber.width(4, this.datetime.getYear(), false));
                move = 4;
            } else if (s.startsWith("YY")) {
                String tmp = "" + this.datetime.getYear();
                if (tmp.length() >= 2) {
                    sb.append(tmp.substring(tmp.length() - 2, tmp.length()));
                } else {
                    sb.append(FormNumber.width(2, tmp, false));
                }
                move = 2;
            } else if (s.startsWith("Y")) {
                sb.append("" + this.datetime.getYear());
                move = 1;
            } else if (s.startsWith("MM")) {
                sb.append(FormNumber.width(2, this.datetime.getMonth(), false));
                move = 2;
            } else if (s.startsWith("M")) {
                sb.append("" + this.datetime.getMonth());
                move = 1;
            } else if (s.startsWith("DD")) {
                sb.append(FormNumber.width(2, this.datetime.getDay(), false));
                move = 2;
            } else if (s.startsWith("D")) {
                sb.append("" + this.datetime.getDay());
                move = 1;
            } else if (s.startsWith("hh")) {
                sb.append(FormNumber.width(2, this.datetime.getHours(), false));
                move = 2;
            } else if (s.startsWith("h")) {
                sb.append("" + this.datetime.getHours());
                move = 1;
            } else if (s.startsWith("mm")) {
                sb.append(FormNumber.width(2, this.datetime.getMinutes(), false));
                move = 2;
            } else if (s.startsWith("m")) {
                sb.append("" + this.datetime.getMinutes());
                move = 1;
            } else if (s.startsWith("ss")) {
                sb.append(FormNumber.width(2, this.datetime.getSeconds(), false));
                move = 2;
            } else if (s.startsWith("s")) {
                sb.append("" + this.datetime.getSeconds());
                move = 1;
            } else {
                sb.append(s.charAt(0));
                move = 1;
            }
            Err.ifEqual(move, 0);
            s = s.substring(move);
        }
        return new Str(sb.toString());
    }

    private Int getDay(CurProc cp) {
        cp.pars();
        return new Int(this.datetime.getDay());
    }

    private Int getMonth(CurProc cp) {
        cp.pars();
        return new Int(this.datetime.getMonth());
    }

    private Int getYear(CurProc cp) {
        cp.pars();
        return new Int(this.datetime.getYear());
    }

    private Int getSeconds(CurProc cp) {
        cp.pars();
        return new Int(this.datetime.getSeconds());
    }

    private Int getMinutes(CurProc cp) {
        cp.pars();
        return new Int(this.datetime.getMinutes());
    }

    private Int getHours(CurProc cp) {
        cp.pars();
        return new Int(this.datetime.getHours());
    }

    private JMo_Date getDate(CurProc cp) {
        return new JMo_Date((MDate)this.datetime.getDate());
    }

    private JMo_Time getTime(CurProc cp) {
        return new JMo_Time((MTime)this.datetime.getTime());
    }

    private I_Object toStr(CurProc cp) {
        cp.pars();
        return new Str(this.datetime.toString());
    }

    private MDateTime getInternalValue() {
        return this.datetime;
    }
}

