/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.form.FormText;
import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_Long
extends A_IntNumber
implements I_Integer,
I_Atomic {
    private final long value;

    public JMo_Long(long val) {
        this.value = val;
    }

    @Override
    public Result_Obj call5(CurProc cp, String method) {
        String string = method;
        string.hashCode();
        return null;
    }

    @Override
    public Integer compareTo2(I_AtomicValue o) {
        if (o instanceof JMo_Long) {
            return new Long(this.value).compareTo(((JMo_Long)o).gValue());
        }
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CurProc cp, ATOMIC to) {
        return Lib_AtomConv.convert(cp, ATOMIC.LONG, to, this, this.gValue());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JMo_Long && ((JMo_Long)obj).gValue() == this.value;
    }

    @Override
    public Long gValue() {
        return this.value;
    }

    @Override
    public String toDebug(CurProc cp) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CurProc cp, COMPARE m) {
        I_Object o = cp.parsExt(this, new Class[][]{{Bool.class, Char.class, A_Number.class}})[0];
        long par = Lib_Convert.getLongValue(cp, o);
        if (m == COMPARE.G) {
            return Bool.getObject(this.value > par);
        }
        if (m == COMPARE.L) {
            return Bool.getObject(this.value < par);
        }
        if (m == COMPARE.GE) {
            return Bool.getObject(this.value >= par);
        }
        if (m == COMPARE.LE) {
            return Bool.getObject(this.value <= par);
        }
        if (m == COMPARE.E) {
            return Bool.getObject(this.value == par);
        }
        if (m == COMPARE.NE) {
            return Bool.getObject(this.value != par);
        }
        throw Err.todo(new Object[]{cp, m});
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP0 op) {
        switch (op) {
            case INC: {
                return new JMo_Long(this.value + 1L);
            }
            case DEC: {
                return new JMo_Long(this.value - 1L);
            }
            case NEG: {
                return new JMo_Long(this.value ^ 0xFFFFFFFFFFFFFFFFL);
            }
            case ABS: {
                return new JMo_Long(Math.abs(this.value));
            }
        }
        throw new CodeError(cp, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op));
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP01 op, I_Object[] pars) {
        if (pars.length == 0) {
            switch (op) {
                case POW: {
                    return new JMo_Long(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
            }
            throw Err.invalid(new Object[]{cp, op, pars});
        }
        A_Number par = (A_Number)cp.parType(pars[0], A_Number.class);
        if (op == A_Number.NOP01.POW && par instanceof JMo_Long) {
            long pari = ((JMo_Long)par).gValue();
            return new JMo_Long(Math.round(Math.pow(this.value, pari)));
        }
        double pard = Lib_Convert.getDoubleValue(cp, par);
        switch (op) {
            case POW: {
                return new Dec(Math.pow(this.value, pard));
            }
            case SQR: {
                return new Dec(Math.exp(Math.log(this.value) / pard));
            }
        }
        throw new CodeError(cp, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + pard);
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP1 op, A_Number paro) {
        long val = this.value;
        if (paro instanceof JMo_Long) {
            int par = Lib_Convert.getIntValue(cp, paro);
            switch (op) {
                case ADD: {
                    return new JMo_Long(this.value + (long)par);
                }
                case SUB: {
                    return new JMo_Long(this.value - (long)par);
                }
                case MUL: {
                    return new JMo_Long(this.value * (long)par);
                }
                case DIV: {
                    if (par == 0) {
                        throw new ExecError(cp, "Division by zero", this.value + "/" + par);
                    }
                    return new Dec((double)this.value / (double)par);
                }
                case MOD: {
                    return new JMo_Long(this.value % (long)par);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(par));
                }
                case LOGR: {
                    return new JMo_Long((int)Math.round(Math.log(this.value) / Math.log(par)));
                }
                case AND: {
                    return new JMo_Long(this.value & (long)par);
                }
                case OR: {
                    return new JMo_Long(this.value | (long)par);
                }
                case XOR: {
                    return new JMo_Long(this.value ^ (long)par);
                }
                case SHL: {
                    return new JMo_Long(this.value << par);
                }
                case SHR: {
                    return new JMo_Long(this.value >> par);
                }
            }
        } else {
            double par = Lib_Convert.getDoubleValue(cp, paro);
            switch (op) {
                case ADD: {
                    return new Dec((double)val + par);
                }
                case SUB: {
                    return new Dec((double)val - par);
                }
                case MUL: {
                    return new Dec((double)val * par);
                }
                case DIV: {
                    if (par == 0.0) {
                        throw new ExecError(cp, "Division by zero", val + "/" + par);
                    }
                    return new Dec((double)val / par);
                }
                case MOD: {
                    return new Dec((double)val % par);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(par));
                }
                case LOGR: {
                    return new JMo_Long((int)Math.round(Math.log(this.value) / Math.log(par)));
                }
                case AND: {
                    return new Dec(Double.longBitsToDouble(this.value & Double.doubleToRawLongBits(par)));
                }
                case OR: {
                    return new Dec(Double.longBitsToDouble(this.value | Double.doubleToRawLongBits(par)));
                }
                case XOR: {
                    return new Dec(Double.longBitsToDouble(this.value ^ Double.doubleToRawLongBits(par)));
                }
                case SHL: {
                    return new Dec(Double.longBitsToDouble(this.value << (int)Double.doubleToRawLongBits(par)));
                }
                case SHR: {
                    return new Dec(Double.longBitsToDouble(this.value >> (int)Double.doubleToRawLongBits(par)));
                }
            }
        }
        throw new CodeError(cp, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + paro.getClass().getSimpleName());
    }

    @Override
    protected I_AtomicValue number_opStr(CurProc cp, A_Number.NOP1 op, A_Atomic p) {
        long val = this.value;
        if (op == A_Number.NOP1.ADD) {
            if (p instanceof Str) {
                return new Str(String.valueOf(val) + ((Str)p).gValue());
            }
            if (p instanceof Char) {
                return new Char((char)(val + (long)((Char)p).gValue().charValue()));
            }
        }
        if (op == A_Number.NOP1.MUL) {
            if (p instanceof Str) {
                String s = FormText.sequence(((Str)p).gValue(), this.value);
                return new Str(s);
            }
            if (p instanceof Char) {
                String s = FormText.sequence(((Char)p).gValue().charValue(), this.value);
                return new Str(s);
            }
        }
        throw new CodeError(cp, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + p.getClass().getSimpleName());
    }

    @Override
    protected final Result_Obj times(CurProc cp, boolean reverse) {
        I_Object[] pars = cp.parsFlex((I_Object)this, null, 0, 1);
        Call stream = cp.getStream();
        Block block = cp.getCallBlock();
        if (pars.length == 0 && stream == null && block == null) {
            throw new CodeError(cp, "Wrong call", "No Parameter, no Stream, no Block, for times ... what to do?");
        }
        I_Object res = this;
        long value = this.gValue();
        if (reverse) {
            long i = value;
            while (i >= 1L) {
                block19: {
                    I_Object it;
                    I_Object i_Object = it = pars.length == 0 ? new JMo_Long(i) : pars[0];
                    if (block != null) {
                        try {
                            res = block.exec(cp, it);
                        }
                        catch (ReturnException e) {
                            Return temp = e.get();
                            switch (temp.getLevel()) {
                                case CONTINUE: {
                                    res = temp.getResult();
                                    break block19;
                                }
                                default: {
                                    return temp.getLoopResult();
                                }
                            }
                        }
                    }
                    if (stream != null) {
                        res = stream.exec(cp, it);
                    }
                }
                --i;
            }
        } else {
            long i = 1L;
            while (i <= value) {
                block20: {
                    I_Object it;
                    I_Object i_Object = it = pars.length == 0 ? new JMo_Long(i) : pars[0];
                    if (block != null) {
                        try {
                            res = block.exec(cp, it);
                        }
                        catch (ReturnException e) {
                            Return temp = e.get();
                            switch (temp.getLevel()) {
                                case CONTINUE: {
                                    res = temp.getResult();
                                    break block20;
                                }
                                default: {
                                    return temp.getLoopResult();
                                }
                            }
                        }
                    }
                    if (stream != null) {
                        res = stream.exec(cp, it);
                    }
                }
                ++i;
            }
        }
        return new Result_Obj(res, true);
    }
}

