/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.cli;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import de.mn77.base.version.Lib_Version;
import de.mn77.base.version.VersionData_ABC;
import de.mn77.lib.terminal.COLOR_BG;
import de.mn77.lib.terminal.COLOR_FG;
import de.mn77.lib.terminal.MTerminal;
import java.io.IOException;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;

public class JMo_CLI {
    public static final boolean DEBUG_AUSGABE = false;
    private static final VersionData_ABC version = new VersionData_ABC(0, 4, 1);

    public static void main(String[] args) {
        MOut.debugNo();
        MOut.setJavaErrors(false);
        MOut.setLineBreak("\r\n");
        try {
            Lib_Version.init(version, false);
            JMo_CLI cli = new JMo_CLI();
            cli.start(args);
        }
        catch (Throwable e) {
            Err.show(e, true);
        }
    }

    public boolean run(Parser_App parser, MTerminal terminal, String in) throws IOException, Err_FileSys {
        String uin = in;
        if (uin == null) {
            uin = this.readline(terminal);
        }
        if (uin == null || uin.equals("exit") || uin.equals("quit") || uin.equals("q")) {
            terminal.print("\r\n");
            terminal.closeTerminal();
            return false;
        }
        String result = this.exec(parser, uin);
        if (terminal != null) {
            terminal.print("\r=> ", result, "\r\n");
        }
        return true;
    }

    public void start(String[] args) throws IOException, Err_FileSys {
        Parser_App parser = new Parser_App();
        if (args.length > 0) {
            MFile datei = new MFile(args[0]);
            if (datei.exists()) {
                App app = parser.parseFile(datei);
                String[] args2 = new String[args.length - 1];
                if (args2.length > 0) {
                    System.arraycopy(args, 1, args2, 0, args2.length);
                }
                app.exec(args2);
            } else {
                this.run(parser, null, args[0]);
            }
        } else {
            MTerminal terminal = new MTerminal();
            this.headline(terminal, parser);
            boolean run = true;
            while (run) {
                run = this.run(parser, terminal, null);
            }
            MOut.text("Good Bye!");
        }
    }

    private String exec(Parser_App parser, String s) throws Err_FileSys {
        try {
            App app = parser.parseText(s);
            return app.exec(null);
        }
        catch (Throwable t) {
            Err.show(t, false);
            return "Java-Error";
        }
    }

    private void headline(MTerminal terminal, Parser_App parser) {
        terminal.print(new Object[]{COLOR_BG.BLUE, COLOR_FG.WHITE, "JM\u00b0", COLOR_BG.DEFAULT});
        terminal.print(new Object[]{COLOR_FG.YELLOW, " " + parser.getVersionString(true, false)});
        terminal.print(new Object[]{COLOR_FG.BROWN, "  /  "});
        terminal.print(new Object[]{COLOR_FG.GREEN, version.toFormat("CLI %1.%2.%3 (%b)")});
        terminal.print(new Object[]{COLOR_FG.BROWN, "  /  "});
        terminal.print(new Object[]{COLOR_FG.LIGHTMAGENTA, parser.getVersion().toFormat("%dd.mm.yyyy")});
        terminal.print("\r\n\n");
    }

    private String readline(MTerminal terminal) throws IOException {
        terminal.print(new Object[]{COLOR_BG.DEFAULT, COLOR_FG.LIGHTBLUE, "JM\u00b0> ", COLOR_FG.DEFAULT});
        String input = terminal.readln();
        terminal.print("\r\n");
        return input;
    }
}

