/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.debug.Stopwatch;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmo_lang.object.I_Object;

public class ClassFinder {
    private static ClassFinder singleton = null;
    private final String pack;
    private final HashMap<String, Class<? extends I_Object>> classes;

    public static void main(String[] args) throws Exception {
        int n;
        MOut.debugMin();
        Stopwatch uhr = new Stopwatch();
        ClassFinder cf = new ClassFinder("jmo");
        Class<? extends I_Object> cl = cf.get("JMo_List");
        MOut.text(cl);
        uhr.print();
        cl = cf.get("JMo_Random");
        MOut.text(cl);
        uhr.print();
        Collection<Class<? extends I_Object>> la = cf.getAll();
        MOut.text(la);
        uhr.print();
        uhr.print();
        ClassLoader classLoader = ClassFinder.class.getClassLoader();
        Enumeration<URL> roots = classLoader.getResources("");
        while (roots.hasMoreElements()) {
            URL url = roots.nextElement();
            MOut.text("URL: " + url.getPath());
            File root = new File(url.getPath());
            File[] files = root.listFiles();
            if (files == null) continue;
            File[] fileArray = files;
            int n2 = files.length;
            n = 0;
            while (n < n2) {
                File file = fileArray[n];
                MOut.text(file.toPath());
                ++n;
            }
        }
        uhr.print();
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(System.getProperty("path.separator"));
        MOut.text("Pfade:", paths);
        String[] stringArray = paths;
        n = paths.length;
        int n3 = 0;
        while (n3 < n) {
            String path = stringArray[n3];
            File file = new File(path);
            if (file.isFile()) {
                ZipEntry e;
                FileInputStream is = new FileInputStream(file);
                ZipInputStream zip = new ZipInputStream(is);
                while ((e = zip.getNextEntry()) != null) {
                    String name = e.getName();
                    if (!name.contains("JMo")) continue;
                    MOut.text("CodeSource: " + name);
                }
            }
            ++n3;
        }
        uhr.print();
    }

    public static ClassFinder getInstance(String pack) {
        if (singleton == null) {
            singleton = new ClassFinder(pack);
        }
        return singleton;
    }

    private ClassFinder(String pack) {
        this.pack = pack;
        try {
            this.classes = this.getClasses(this.pack);
        }
        catch (Exception e) {
            throw Err.show(e, true);
        }
    }

    public Class<? extends I_Object> get(String name) {
        return this.classes.get(name);
    }

    public Collection<Class<? extends I_Object>> getAll() {
        return this.classes.values();
    }

    private void addItem(List<Class> classes, String base, String line) throws ClassNotFoundException {
        String filename = line.substring(line.lastIndexOf(47) + 1);
        if (filename.endsWith(".class") && filename.startsWith("JMo_") && !filename.contains("$")) {
            String classline;
            Class<?> c;
            String dotline = line.substring(base.length());
            if (dotline.startsWith("/")) {
                dotline = dotline.substring(1);
            }
            if (I_Object.class.isAssignableFrom(c = Class.forName(classline = (dotline = dotline.replaceAll("[/]", ".")).substring(0, dotline.lastIndexOf(46))))) {
                classes.add(c);
            }
        }
    }

    private HashMap<String, Class<? extends I_Object>> getClasses(String pack) throws Exception {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            CodeSource src = ClassFinder.class.getProtectionDomain().getCodeSource();
            if (src.getLocation().toString().toLowerCase().endsWith(".jar")) {
                this.getClassesFromJar2(classes);
            } else {
                this.getClassesDirect(classes);
            }
        }
        catch (Exception e) {
            Err.show(e, true);
        }
        HashMap<String, Class<? extends I_Object>> map = new HashMap<String, Class<? extends I_Object>>();
        for (Class c : classes) {
            map.put(c.getSimpleName(), c);
        }
        return map;
    }

    private void getClassesDirect(List<Class> classes) throws IOException, URISyntaxException, ClassNotFoundException {
        Enumeration<URL> eu = ClassFinder.class.getClassLoader().getResources("");
        while (eu.hasMoreElements()) {
            URI uri = eu.nextElement().toURI();
            Path myPath = Paths.get(uri);
            String base = myPath.toString();
            Stream<Path> walk = Files.walk(myPath, Integer.MAX_VALUE, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                String line = ((Path)it.next()).toString();
                this.addItem(classes, base, line);
            }
            walk.close();
        }
    }

    private void getClassesFromJar2(List<Class> classes) throws IOException, ClassNotFoundException {
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(System.getProperty("path.separator"));
        ArrayList<String> scanned = new ArrayList<String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (scanned.indexOf(path) < 0) {
                scanned.add(path);
                File file = new File(path);
                if (file.isFile() && file.getName().startsWith("jmo")) {
                    ZipEntry e;
                    FileInputStream is = new FileInputStream(file);
                    ZipInputStream zip = new ZipInputStream(is);
                    while ((e = zip.getNextEntry()) != null) {
                        String name = e.getName();
                        this.addItem(classes, "", name);
                    }
                    zip.close();
                }
            }
            ++n2;
        }
    }
}

