/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.sys.MOut;
import java.util.HashMap;
import java.util.Map;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Parser;

public class FuncManager {
    private HashMap<String, Function> func;

    public void add(String name, Function f) {
        if (this.func == null) {
            this.func = new HashMap();
        }
        this.func.put(name, f);
    }

    public void describe(CurProc cp, int depth) {
        String space = Lib_Parser.space(depth);
        if (this.func != null) {
            for (Map.Entry<String, Function> g : this.func.entrySet()) {
                MOut.text(String.valueOf(space) + ":" + g.getKey());
                g.getValue().describe(cp, depth + 1);
            }
        }
    }

    public Function get(CurProc cp, String method) {
        if (this.func == null) {
            throw new CodeError(cp, "Unknown Function", "_THIS." + method);
        }
        Function f = this.func.getOrDefault(method, null);
        if (f == null) {
            throw new CodeError(cp, "Unknown Function", "_THIS." + method);
        }
        return f;
    }

    public boolean knows(String name) {
        if (this.func == null) {
            return false;
        }
        return this.func.containsKey(name);
    }
}

