/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.HashMap;
import java.util.Map;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Parser;

public abstract class A_VarManager<T extends I_Object> {
    private final A_VarManager<T> parent;
    private final HashMap<String, T> vars;

    public A_VarManager(A_VarManager<T> parent) {
        this.parent = parent;
        this.vars = new HashMap();
    }

    public int count() {
        return this.vars == null ? 0 : this.vars.size();
    }

    public T create(String name) {
        T vo = this.iUse(name, false);
        if (vo != null) {
            return vo;
        }
        vo = this.pCreateNew(name);
        this.vars.put(name, vo);
        return vo;
    }

    public void describe(CurProc cp, int depth) {
        if (this.vars != null) {
            for (Map.Entry<String, T> g : this.vars.entrySet()) {
                ((I_Object)g.getValue()).describe(cp, depth);
            }
        }
    }

    public void describe(int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + "Items:");
        if (this.vars != null && !this.vars.isEmpty()) {
            MOut.text(String.valueOf(space) + this.vars.toString());
        } else {
            MOut.text(String.valueOf(space) + "  none");
        }
        MOut.text(String.valueOf(space) + "Parent:");
        if (this.parent == null) {
            MOut.text(String.valueOf(space) + "  none");
        } else {
            this.parent.describe(left + 1);
        }
    }

    public boolean knows(String name) {
        if (this.vars.keySet().contains(name)) {
            return true;
        }
        return this.parent != null && this.parent.knows(name);
    }

    public T use(String name) {
        return this.iUse(name, true);
    }

    protected abstract T pCreateNew(String var1);

    private T iUse(String name, boolean error) {
        if (this.parent == this) {
            Err.invalid(name);
        }
        if (this.vars.keySet().contains(name)) {
            return (T)((I_Object)this.vars.get(name));
        }
        if (this.parent != null && this.parent.knows(name)) {
            return this.parent.use(name);
        }
        if (error) {
            throw Err.forbidden("Access to unknown variable: " + name);
        }
        return null;
    }
}

