/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.datetime;

import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_Time
extends A_Object {
    private MTime time = null;
    private final Call[] init;

    public JMo_Time(MTime time) {
        this.init = null;
        this.time = time;
    }

    public JMo_Time() {
        this.init = null;
    }

    public JMo_Time(Call str) {
        this.init = new Call[]{str};
    }

    public JMo_Time(Call h, Call m, Call s) {
        this.init = new Call[]{h, m, s};
    }

    @Override
    public void init(CurProc cp) {
        if (this.time != null) {
            return;
        }
        if (this.init == null) {
            this.time = new MTime();
        } else if (this.init.length == 1) {
            String s = Lib_Convert.getStringValue(cp, this.init[0].exec(cp, null));
            this.time = new MTime(s);
        } else {
            int ih = Lib_Convert.getIntValue(cp, this.init[0].exec(cp, null));
            int im = Lib_Convert.getIntValue(cp, this.init[1].exec(cp, null));
            int is = Lib_Convert.getIntValue(cp, this.init[2].exec(cp, null));
            this.time = new MTime(ih, im, is);
        }
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "hour": 
            case "hours": {
                return JMo_Time.stdResult(this.getHours(cp));
            }
            case "min": 
            case "minutes": {
                return JMo_Time.stdResult(this.getMinutes(cp));
            }
            case "sec": 
            case "seconds": {
                return JMo_Time.stdResult(this.getSeconds(cp));
            }
            case "toStr": {
                return JMo_Time.stdResult(this.toStr(cp));
            }
            case "format": {
                return JMo_Time.stdResult(this.format(cp));
            }
            case "diffHours": {
                return JMo_Time.stdResult(this.diffHours(cp));
            }
            case "diffMinutes": {
                return JMo_Time.stdResult(this.diffMinutes(cp));
            }
            case "diffSeconds": {
                return JMo_Time.stdResult(this.diffSeconds(cp));
            }
            case "==": 
            case "equal": {
                return JMo_Time.stdResult(this.compare(cp, COMPARE.E));
            }
            case "!=": 
            case "differs": {
                return JMo_Time.stdResult(this.compare(cp, COMPARE.NE));
            }
            case ">": 
            case "greater": {
                return JMo_Time.stdResult(this.compare(cp, COMPARE.G));
            }
            case "lesser": 
            case "<": {
                return JMo_Time.stdResult(this.compare(cp, COMPARE.L));
            }
            case ">=": 
            case "greaterOrEqual": {
                return JMo_Time.stdResult(this.compare(cp, COMPARE.GE));
            }
            case "<=": 
            case "lesserOrEqual": {
                return JMo_Time.stdResult(this.compare(cp, COMPARE.LE));
            }
        }
        return null;
    }

    @Override
    public void describe(CurProc cp, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cp));
    }

    @Override
    public String toDebug(CurProc cp) {
        if (this.time == null) {
            return "Time";
        }
        return "Time(" + this.toString() + ")";
    }

    @Override
    public String toString() {
        if (this.time == null) {
            return "Time";
        }
        return this.time.toString();
    }

    private Bool compare(CurProc cp, COMPARE co) {
        JMo_Time other = (JMo_Time)cp.pars(this, JMo_Time.class)[0];
        boolean isEqual = this.time.isEqual(other.getInternalValue());
        boolean isGreater = this.time.isGreater(other.getInternalValue());
        boolean result = false;
        switch (co) {
            case E: {
                result = isEqual;
                break;
            }
            case NE: {
                result = !isEqual;
                break;
            }
            case L: {
                result = !isEqual && !isGreater;
                break;
            }
            case LE: {
                result = isEqual || !isGreater;
                break;
            }
            case G: {
                result = isGreater;
                break;
            }
            case GE: {
                result = isEqual || isGreater;
            }
        }
        return Bool.getObject(result);
    }

    private Int diffSeconds(CurProc cp) {
        JMo_Time par = (JMo_Time)cp.pars(this, JMo_Time.class)[0];
        int diff = this.time.diffSeconds(par.getInternalValue());
        return new Int(diff);
    }

    private Int diffMinutes(CurProc cp) {
        JMo_Time par = (JMo_Time)cp.pars(this, JMo_Time.class)[0];
        int diff = this.time.diffMinutes(par.getInternalValue());
        return new Int(diff);
    }

    private Int diffHours(CurProc cp) {
        JMo_Time par = (JMo_Time)cp.pars(this, JMo_Time.class)[0];
        int diff = this.time.diffHours(par.getInternalValue());
        return new Int(diff);
    }

    private I_Object format(CurProc cp) {
        String s = ((Str)cp.pars(this, Str.class)[0]).gValue();
        StringBuilder sb = new StringBuilder();
        s = s.toLowerCase();
        while (s.length() > 0) {
            int move = 0;
            if (s.startsWith("hh")) {
                sb.append(FormNumber.width(2, this.time.getHours(), false));
                move = 2;
            } else if (s.startsWith("h")) {
                sb.append("" + this.time.getHours());
                move = 1;
            } else if (s.startsWith("mm")) {
                sb.append(FormNumber.width(2, this.time.getMinutes(), false));
                move = 2;
            } else if (s.startsWith("m")) {
                sb.append("" + this.time.getMinutes());
                move = 1;
            } else if (s.startsWith("ss")) {
                sb.append(FormNumber.width(2, this.time.getSeconds(), false));
                move = 2;
            } else if (s.startsWith("s")) {
                sb.append("" + this.time.getSeconds());
                move = 1;
            } else {
                sb.append(s.charAt(0));
                move = 1;
            }
            Err.ifEqual(move, 0);
            s = s.substring(move);
        }
        return new Str(sb.toString());
    }

    private Int getSeconds(CurProc cp) {
        cp.pars();
        return new Int(this.time.getSeconds());
    }

    private Int getMinutes(CurProc cp) {
        cp.pars();
        return new Int(this.time.getMinutes());
    }

    private Int getHours(CurProc cp) {
        cp.pars();
        return new Int(this.time.getHours());
    }

    private I_Object toStr(CurProc cp) {
        cp.pars();
        return new Str(this.time.toString());
    }

    private MTime getInternalValue() {
        return this.time;
    }
}

