/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public class JMo_For
extends A_Object
implements I_AutoBlockDo {
    private ParCallBuffer start;
    private ParCallBuffer end;
    private ParCallBuffer step;

    public JMo_For(Call end_or_range) {
        this(end_or_range, null, null);
    }

    public JMo_For(Call start, Call end) {
        this(start, end, null);
    }

    public JMo_For(Call start, Call end, Call step) {
        this.start = new ParCallBuffer(start);
        this.end = end == null ? null : new ParCallBuffer(end);
        this.step = step == null ? null : new ParCallBuffer(step);
    }

    @Override
    public void init(CurProc cp) {
        this.start.initExt(cp, this, A_Number.class, Bool.class, Char.class, JMo_Range.class);
        if (this.end != null) {
            this.end.initExt(cp, this, A_Number.class, Bool.class, Char.class);
        }
        if (this.step != null) {
            this.step.init(cp, this, A_Number.class);
        }
        if (this.start != null && this.start.get() instanceof JMo_Range && this.step != null) {
            throw new CodeError(cp, "Wrong count of parameters", "Only 1 or 2 parameters are allowed with range");
        }
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "do": 
            case "each": {
                return this.each(cp, false, true);
            }
            case "toList": {
                return this.each(cp, true, true);
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CurProc cp) {
        return this.each((CurProc)cp, (boolean)false, (boolean)true).obj;
    }

    @Override
    public void describe(CurProc cp, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cp));
    }

    public Result_Obj each(CurProc cpOld, boolean toList, boolean execBlockStream) {
        ArrayList<I_Object> list;
        if (cpOld.call == null && execBlockStream) {
            Err.invalid(cpOld.call, toList, execBlockStream);
        }
        boolean varlet = false;
        I_Object[] pars = null;
        if (execBlockStream) {
            pars = cpOld.parsFlex((I_Object)this, null, 0, 1);
            varlet = pars.length == 1 && pars[0] instanceof VarLet;
        }
        Call stream = null;
        Block block = null;
        if (execBlockStream) {
            block = cpOld.getCallBlock();
            stream = cpOld.getStream();
        }
        I_Object res = this;
        ArrayList<I_Object> arrayList = list = toList ? new ArrayList<I_Object>() : null;
        if (Lib_Type.typeIs(cpOld, this.start.get(), JMo_Range.class)) {
            if (this.step != null) {
                throw new CodeError(cpOld, "Wrong parameter-count", "With Range, only 1 or 2 pars are allowed.");
            }
            Group2<I_Object, I_Object> range = ((JMo_Range)this.start.get()).getValues();
            this.start = new ParCallBuffer(new Call(cpOld.getSurrBlock(), range.g1(), cpOld.getDebugInfo()));
            this.start.initExt(cpOld, this, A_Number.class, Char.class);
            if (this.end != null) {
                this.step = this.end;
            }
            this.end = new ParCallBuffer(new Call(cpOld.getSurrBlock(), range.g2(), cpOld.getDebugInfo()));
            this.end.initExt(cpOld, this, A_Number.class, Char.class);
        }
        if (this.start != null && this.end == null && this.step == null) {
            this.end = this.start;
            this.start = new ParCallBuffer(new Call(cpOld.getSurrBlock(), new Int(1), cpOld.getDebugInfo()));
            this.start.init(cpOld, this, Int.class);
        }
        if (execBlockStream && stream == null && block == null) {
            return new Result_Obj(this.end.get(), true);
        }
        CurProc cpNew = cpOld.copyLoop(new Handle_Loop(this));
        if (Lib_Type.typeIs(cpNew, this.start.get(), I_Integer.class, Char.class) && Lib_Type.typeIs(cpNew, this.end.get(), I_Integer.class, Char.class) && (this.step == null || Lib_Type.typeIs(cpNew, this.step.get(), I_Integer.class))) {
            int i3;
            boolean desc;
            int i1 = Lib_Convert.getIntValue(cpNew, this.start.get());
            int i2 = Lib_Convert.getIntValue(cpNew, this.end.get());
            boolean bl = desc = i2 < i1;
            int n = this.step == null ? (desc ? -1 : 1) : (i3 = Lib_Convert.getIntValue(cpNew, this.step.get()));
            if (desc && i3 > 0 || !desc && i3 < 0) {
                throw new ExecError(cpNew, "Endless running loop", "From " + i1 + " to " + i2 + " with stepping " + i3);
            }
            int i = 0;
            I_Object it2 = null;
            i = i1;
            while (!(desc ? i < i2 : i > i2)) {
                block38: {
                    boolean last = desc ? i <= i2 : i >= i2;
                    it2 = Lib_Convert.intToObject(Lib_Type.getType(cpNew, this.start.get()), i);
                    if (toList) {
                        list.add(it2);
                    } else {
                        if (varlet) {
                            Var o = ((VarLet)pars[0]).getVar();
                            o.set(cpNew, cpNew, it2);
                        }
                        if (block != null) {
                            try {
                                res = block.exec(cpNew, it2);
                            }
                            catch (ReturnException e) {
                                Return ro = e.get();
                                switch (ro.getLevel()) {
                                    case CONTINUE: {
                                        res = ro.getResult();
                                        break block38;
                                    }
                                    default: {
                                        return ro.getLoopResult();
                                    }
                                }
                            }
                        }
                        if (stream != null && block == null) {
                            res = stream.exec(cpNew, it2);
                        }
                    }
                    if (!last) {
                        i1 = Lib_Convert.getIntValue(cpNew, this.start.getNew(cpNew));
                        i2 = Lib_Convert.getIntValue(cpNew, this.end.getNew(cpNew));
                        boolean bl2 = desc = i2 < i1;
                        i3 = this.step == null ? (desc ? -1 : 1) : Lib_Convert.getIntValue(cpNew, cpNew.parType(this.step.getNew(cpNew), Int.class));
                    }
                }
                i += i3;
            }
            if (stream != null && block != null) {
                res = stream.exec(cpNew, it2);
            }
        } else if (Lib_Type.typeIs(cpNew, this.start.get(), I_Decimal.class, I_Integer.class) && Lib_Type.typeIs(cpNew, this.end.get(), I_Decimal.class, I_Integer.class) && (this.step == null || Lib_Type.typeIs(cpNew, this.step.get(), I_Decimal.class, I_Integer.class))) {
            double d3;
            boolean desc;
            double d1 = Lib_Convert.getDoubleValue(cpNew, this.start.get());
            double d2 = Lib_Convert.getDoubleValue(cpNew, this.end.get());
            boolean bl = desc = d2 < d1;
            double d = this.step == null ? (double)(desc ? -1 : 1) : (d3 = Lib_Convert.getDoubleValue(cpNew, this.step.get()));
            if (desc && d3 > 0.0 || !desc && d3 < 0.0) {
                throw new ExecError(cpNew, "Endless running Counter", "From " + d1 + " to " + d2 + " with stepping " + d3);
            }
            double d4 = d1;
            while (!(desc ? !(d4 >= d2) : !(d4 <= d2))) {
                block39: {
                    d4 = Lib_Math.normalize(d4, 10);
                    Dec it2 = new Dec(d4);
                    if (toList) {
                        list.add(it2);
                    } else {
                        if (varlet) {
                            Var o = ((VarLet)pars[0]).getVar();
                            o.set(cpNew, cpNew, it2);
                        }
                        if (block != null) {
                            try {
                                res = block.exec(cpNew, it2);
                            }
                            catch (ReturnException e) {
                                Return temp = e.get();
                                switch (temp.getLevel()) {
                                    case CONTINUE: {
                                        res = temp.getResult();
                                        break block39;
                                    }
                                    default: {
                                        return temp.getLoopResult();
                                    }
                                }
                            }
                        }
                        if (stream != null) {
                            res = stream.exec(cpNew, it2);
                        }
                    }
                    d1 = Lib_Convert.getDoubleValue(cpNew, this.start.getNew(cpNew));
                    d2 = Lib_Convert.getDoubleValue(cpNew, this.end.getNew(cpNew));
                    boolean bl3 = desc = d2 < d1;
                    d3 = this.step == null ? (double)(desc ? -1 : 1) : Lib_Convert.getDoubleValue(cpNew, cpNew.parTypeExt(this.step.getNew(cpNew), A_Number.class));
                }
                d4 += d3;
            }
        } else {
            throw new CodeError(cpNew, "Wrong parameters", this.toDebug(cpNew));
        }
        return toList ? new Result_Obj(new JMo_List(list), false) : new Result_Obj(res, true);
    }

    @Override
    public String toDebug(CurProc cp) {
        return this.toString();
    }

    @Override
    public String toString() {
        return this.step == null ? "For(" + this.start.toString() + "," + this.end.toString() + ")" : "For(" + this.start.toString() + "," + this.end.toString() + "," + this.step.toString() + ")";
    }
}

