/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.thread;

import de.mn77.base.data.struct.CacheList;
import de.mn77.base.error.Err;

public class ThreadQueue {
    private final CacheList<ThreadQueue> stack = new CacheList();
    private Thread current = null;

    public synchronized void exit() {
        this.current = null;
        if (!this.stack.isEmpty()) {
            this.stack.getNext().notify();
        }
    }

    public synchronized boolean entrance() throws Exception {
        if (this.current != null && this.current.equals(Thread.currentThread())) {
            return true;
        }
        if (!this.stack.isEmpty() || this.current != null) {
            this.stack.add(this);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw Err.wrap(e, this.current, this.stack);
            }
        } else {
            this.current = Thread.currentThread();
        }
        return false;
    }
}

