/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.data.filter.FilterText;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.I_FileSys_Item;
import de.mn77.base.sys.file.MDir;
import de.mn77.base.sys.file.MFile;
import java.io.File;
import java.io.IOException;

public class MFileSys {
    public static I_Directory root() {
        try {
            return new MDir(File.listRoots()[0]);
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static I_Directory temp() {
        try {
            return new MDir(Sys.getPathTemp());
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static I_Directory home() {
        try {
            return new MDir(Sys.getPathHome());
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static I_Directory current() {
        try {
            return new MDir(Sys.getCurrentDir());
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static I_Directory dirAppData() throws Err_FileSys {
        if (Sys.isLinux()) {
            return MFileSys.home();
        }
        if (Sys.isWindows()) {
            if (Double.parseDouble(Sys.getOsVersion()) >= 10.0) {
                return MFileSys.home().dirFlex("AppData").dirFlex("Local");
            }
            return MFileSys.home().dirFlex("Anwendungsdaten");
        }
        if (Sys.isMac()) {
            return MFileSys.home();
        }
        throw Err.todo("App-Data-Folder not configured for this System.", Sys.getOsName(), Sys.getOsVersion());
    }

    public static I_Directory dirAppData_Nitsche(String app) throws Err_FileSys {
        Err.ifEmpty(app);
        app = FilterText.trim(app);
        app = app.replace(' ', '_');
        String basis = Sys.isWindows() ? "Nitsche Michael" : "nitsche-michael";
        I_Directory anw = MFileSys.dirAppData_Dir(basis);
        return anw.dirFlex(app);
    }

    public static I_Directory dirAppData_Dir(String dir) throws Err_FileSys {
        Err.ifEmpty(dir);
        I_Directory anw = MFileSys.dirAppData();
        dir = FilterText.trim(dir);
        if (Sys.isLinux() || Sys.isMac()) {
            return anw.dirFlex("." + dir);
        }
        if (Sys.isWindows()) {
            return anw.dirFlex(dir);
        }
        throw Err.todo("App-Data-Folder not configured for this System.", Sys.getOsName());
    }

    public static I_FileSys_Item convertFrom(File file) {
        try {
            return file.isDirectory() ? new MDir(file) : new MFile(file);
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static MFile createTemp(String filename, String suffix) throws IOException {
        if (suffix.charAt(0) != '.') {
            suffix = "." + suffix;
        }
        File tempFile = File.createTempFile(String.valueOf(filename) + "_", suffix);
        tempFile.deleteOnExit();
        return new MFile(tempFile);
    }
}

