/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.sys.file.I_FileSys_Item;
import java.io.File;

public abstract class A_FileSys_Item
implements I_FileSys_Item {
    protected File file;

    @Override
    public boolean equals(Object to) {
        if (to instanceof I_FileSys_Item) {
            return this.isEqual((I_FileSys_Item)to);
        }
        return false;
    }

    @Override
    public boolean isEqual(I_FileSys_Item to) {
        return to.getPathAbsolute().equals(this.getPathAbsolute());
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public String getPathAbsolute() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isGreater(I_FileSys_Item than) {
        return this.compareTo(than) == 1;
    }

    @Override
    public int compareTo(I_FileSys_Item other) {
        String path2;
        String path1 = this.getPathAbsolute();
        if (Lib_Compare.isEqual(path1, path2 = other.getPathAbsolute())) {
            return 0;
        }
        if (Lib_Compare.isGreater(path1, path2)) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return this.file.toString();
    }
}

