/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.struct.MultiCallItems;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.struct.runtime.VarEnv;

public class VarConstEnv {
    private static int counter = 0;
    private final int nr;
    public final VarEnv vars;
    public final VarEnv cons;
    private final VarConstEnv parent;
    private MultiCallItems multicall = null;
    private Handle_Loop loop = null;

    public VarConstEnv(VarConstEnv parent) {
        this.parent = parent;
        VarEnv parentVars = parent == null ? null : parent.vars;
        VarEnv parentCons = parent == null ? null : parent.cons;
        this.vars = new VarEnv(parentVars);
        this.cons = new VarEnv(parentCons);
        this.nr = ++counter;
    }

    public MultiCallItems useMultiCall() {
        if (this.multicall == null && this.parent != null) {
            this.multicall = this.parent.useMultiCall();
        }
        if (this.multicall == null) {
            this.multicall = new MultiCallItems();
        }
        return this.multicall;
    }

    public void loopSet(Handle_Loop handle) {
        if (this.loop != null) {
            Err.invalid("Loop is already set!");
        }
        this.loop = handle;
    }

    public Handle_Loop loopGet(CurProc cp) {
        if (this.loop != null) {
            return this.loop;
        }
        if (this.parent != null) {
            return this.parent.loopGet(cp);
        }
        throw new CodeError(cp, "Unknown loop!", "There's no loop known, in this and the parent blocks");
    }

    public VarConstEnv getParent() {
        return this.parent;
    }

    public String toString() {
        String sp = this.parent == null ? "" : " --> Parent: " + this.parent.toString();
        return "VCE" + this.nr + sp;
    }
}

