/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.pseudo;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.form.FormText;
import de.mn77.base.error.I_Error;
import org.jmo_lang.error.CustomError;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ParCallBuffer;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;

public class JMo_Error
extends A_Object {
    private final Throwable ex;
    private final ParCallBuffer par1;
    private final ParCallBuffer par2;

    public JMo_Error(Throwable t) {
        this.ex = t;
        this.par1 = null;
        this.par2 = null;
    }

    public JMo_Error(Call par1, Call par2) {
        this.ex = new Throwable();
        this.par1 = new ParCallBuffer(par1);
        this.par2 = new ParCallBuffer(par2);
    }

    @Override
    public void init(CurProc cp) {
        if (this.par1 != null) {
            this.par1.init(cp, this);
        }
        if (this.par2 != null) {
            this.par2.init(cp, this);
        }
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "do": 
            case "throw": {
                this.iThrow(cp);
                return new Result_Obj(Nil.NIL, true);
            }
            case "message": {
                cp.pars();
                return JMo_Error.stdResult(new Str(this.ex.getLocalizedMessage()));
            }
            case "source": {
                cp.pars();
                return this.ex instanceof ErrorBaseDebug ? JMo_Error.stdResult(new Str(((ErrorBaseDebug)this.ex).getSource())) : JMo_Error.stdResult(Nil.NIL);
            }
            case "call": {
                cp.pars();
                return this.ex instanceof ErrorBaseDebug ? JMo_Error.stdResult(new Str(((ErrorBaseDebug)this.ex).getCall())) : JMo_Error.stdResult(Nil.NIL);
            }
            case "detail": {
                cp.pars();
                return this.ex instanceof ErrorBaseDebug ? JMo_Error.stdResult(new Str(((ErrorBaseDebug)this.ex).getDetail())) : JMo_Error.stdResult(Nil.NIL);
            }
            case "instance": {
                cp.pars();
                return this.ex instanceof ErrorBaseDebug ? JMo_Error.stdResult(new Str(((ErrorBaseDebug)this.ex).getInstance())) : JMo_Error.stdResult(Nil.NIL);
            }
            case "group": {
                cp.pars();
                return JMo_Error.stdResult(new Str(((ErrorBaseDebug)this.ex).getGroup().title));
            }
        }
        return null;
    }

    private void iThrow(CurProc cp) {
        if (this.par1 != null && this.par2 != null) {
            throw new CustomError(cp, FormText.unquote(this.par1.toString()), FormText.unquote(this.par2.toString()));
        }
        throw new CustomError(cp, "Thrown again", this.iMessageToString());
    }

    @Override
    public String toDebug(CurProc cp) {
        if (this.par1 != null && this.par2 != null) {
            return "Error(" + this.par1.toDebug(cp) + "," + this.par2.toDebug(cp) + ")";
        }
        return "Error " + this.iMessageToString();
    }

    @Override
    public String toString() {
        if (this.par1 != null && this.par2 != null) {
            return "Error(" + this.par1.toString() + "," + this.par2.toString() + ")";
        }
        return "Error " + this.iMessageToString();
    }

    private String iMessageToString() {
        String s;
        String message = this.ex.getLocalizedMessage();
        String string = s = message != null ? ": " + message : ": Unknown";
        if (this.ex instanceof I_Error) {
            for (Object o : ((I_Error)((Object)this.ex)).getDetails()) {
                s = String.valueOf(s) + "\n" + ConvObject.toText(o);
            }
        }
        return s;
    }
}

