/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.Lib_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.A_FileSys;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;

public class JMo_File
extends A_FileSys
implements I_Object {
    private final Call par;
    private File file = null;

    public JMo_File(Call par) {
        Err.ifNull(par);
        this.par = par;
    }

    public JMo_File(File file) {
        Err.ifNull(file);
        this.file = file;
        this.par = null;
    }

    @Override
    public void init2(CurProc cp) {
        if (this.par != null) {
            I_Object filename = this.par.exec(cp, null);
            if (!((filename = Lib_Convert.getValue(cp, filename)) instanceof Str)) {
                throw Err.invalid(filename.toDebug(cp));
            }
            String sFile = ((Str)filename).gValue();
            this.file = new File(sFile);
        }
    }

    @Override
    public Result_Obj call3(CurProc cp) {
        Err.ifNull(this.file);
        switch (cp.getMethod()) {
            case "suffix": {
                return JMo_File.stdResult(this.getSuffix(cp));
            }
            case "size": {
                return JMo_File.stdResult(this.getSize(cp));
            }
            case "exec": 
            case "open": {
                return JMo_File.stdResult(this.open(cp));
            }
            case "create": {
                return JMo_File.stdResult(this.create(cp));
            }
            case "readLines": 
            case "lines": {
                return this.readLines(cp);
            }
            case "read": {
                return JMo_File.stdResult(this.read(cp));
            }
        }
        return null;
    }

    @Override
    public void describe(CurProc cp, int left) {
        super.describe(cp, left);
        if (this.par != null) {
            this.par.describe(cp, left + 4);
        }
    }

    @Override
    public String toDebug(CurProc cp) {
        String p = Lib_Output.toDebug(cp, this.par);
        if (p.length() != 0) {
            p = "(" + p + ")";
        }
        return "File" + p;
    }

    @Override
    public String toString() {
        return this.file == null ? "Unknown File" : this.file.getAbsolutePath();
    }

    @Override
    protected File pFile() {
        return this.file;
    }

    @Override
    protected I_Object rename(CurProc cp) {
        Str par = (Str)cp.pars(this, Str.class)[0];
        String newName = Lib_Convert.getStringValue(cp, par);
        if (newName.contains(Sys.getSeperatorDir())) {
            throw new ExtError(cp, "File-Rename failed", "No target-path allowed");
        }
        newName = String.valueOf(this.file.getParent()) + Sys.getSeperatorDir() + newName;
        File newFile = new File(newName);
        boolean done = this.file.renameTo(newFile);
        if (!done) {
            throw new ExtError(cp, "File-Rename failed", String.valueOf(this.file.getAbsolutePath()) + " --> " + newFile.getAbsolutePath());
        }
        return new JMo_File(newFile);
    }

    private JMo_File create(CurProc cp) {
        cp.pars();
        boolean ok = false;
        try {
            ok = this.file.createNewFile();
        }
        catch (IOException e) {
            ok = false;
        }
        if (!ok) {
            throw new ExtError(cp, "Can't create File", this.file.getAbsolutePath());
        }
        return this;
    }

    private Int getSize(CurProc cp) {
        cp.pars();
        long l = this.file.length();
        if (l > Integer.MAX_VALUE) {
            throw new ExecError(cp, "Int out of range", String.valueOf(l) + " Bytes");
        }
        return new Int((int)l);
    }

    private Str getSuffix(CurProc cp) {
        cp.pars();
        String suffix = Lib_FileSys.getSuffix(this.file);
        return new Str(suffix);
    }

    private JMo_File open(CurProc cp) {
        try {
            Lib_FileSys.start(this.file);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cp, "Can't create File", this.file.getAbsolutePath());
        }
        return this;
    }

    private Str read(CurProc cp) {
        cp.pars();
        try {
            String content = Lib_TextFile.read(this.file, true);
            return new Str(content);
        }
        catch (Err_FileSys e) {
            Err.show(e, false);
            throw new ExtError(cp, "File-Access-Error", e.getLocalizedMessage());
        }
    }

    private Result_Obj readLines(CurProc cp) {
        cp.parsWithBlock(this, new Class[0]);
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        try {
            I_List<String> lines = Lib_TextFile.readLines(this.file, true);
            for (String line : lines) {
                list.add(new Str(line));
            }
        }
        catch (Err_FileSys e) {
            Err.show(e, true);
        }
        JMo_List result = new JMo_List(list);
        if (cp.getCallBlock() != null) {
            return new Result_Obj(result.autoBlockDo(cp), true);
        }
        return new Result_Obj(result, false);
    }
}

