/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import java.io.File;
import java.io.IOException;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;

public abstract class A_FileSys
extends A_Object {
    @Override
    public final void init(CurProc cp) {
        this.init2(cp);
    }

    @Override
    public final Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "exist": {
                return A_FileSys.stdResult(this.exist(cp));
            }
            case "==": {
                return A_FileSys.stdResult(this.equals2(cp));
            }
            case "parent": {
                return A_FileSys.stdResult(this.getParent(cp));
            }
            case "name": {
                return A_FileSys.stdResult(this.getName(cp));
            }
            case "isDir": {
                return A_FileSys.stdResult(this.isDir(cp));
            }
            case "isFile": {
                return A_FileSys.stdResult(this.isFile(cp));
            }
            case "isHidden": {
                return A_FileSys.stdResult(this.isHidden(cp));
            }
            case "rename": {
                return A_FileSys.stdResult(this.rename(cp));
            }
            case "move": {
                return A_FileSys.stdResult(this.move(cp));
            }
            case "delete": {
                return A_FileSys.stdResult(this.delete(cp));
            }
        }
        return this.call3(cp);
    }

    public abstract Result_Obj call3(CurProc var1);

    @Override
    public boolean equals(Object o) {
        if (o instanceof I_AtomicValue) {
            return ((A_FileSys)o).pFile().equals(this.pFile());
        }
        return super.equals(o);
    }

    public abstract void init2(CurProc var1);

    protected abstract File pFile();

    protected abstract I_Object rename(CurProc var1);

    private I_Object delete(CurProc cp) {
        try {
            throw new ExtError(cp, "File-Delete-Forbidden", this.pFile().getCanonicalPath());
        }
        catch (IOException e) {
            throw new ExtError(cp, "File-Delete-Forbidden", this.pFile().getAbsolutePath());
        }
    }

    private Bool equals2(CurProc cp) {
        A_FileSys par = (A_FileSys)cp.pars(this, A_FileSys.class)[0];
        File pf = par.pFile();
        return Bool.getObject(this.pFile().equals(pf));
    }

    private Bool exist(CurProc cp) {
        cp.pars();
        return Bool.getObject(this.pFile().exists());
    }

    private I_Object getName(CurProc cp) {
        cp.pars();
        return new Str(this.pFile().getName());
    }

    private JMo_Dir getParent(CurProc cp) {
        cp.pars();
        return new JMo_Dir(this.pFile().getParentFile());
    }

    private Bool isDir(CurProc cp) {
        cp.pars();
        return Bool.getObject(this.pFile().isDirectory());
    }

    private Bool isFile(CurProc cp) {
        cp.pars();
        return Bool.getObject(this.pFile().isFile());
    }

    private Bool isHidden(CurProc cp) {
        cp.pars();
        return Bool.getObject(this.pFile().isHidden());
    }

    private I_Object move(CurProc cp) {
        try {
            throw new ExtError(cp, "File-Move-Forbidden", this.pFile().getCanonicalPath());
        }
        catch (IOException e) {
            throw new ExtError(cp, "File-Move-Forbidden", this.pFile().getAbsolutePath());
        }
    }
}

