/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.form.FormText;
import de.mn77.base.error.Err;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;

public class Char
extends A_Atomic
implements I_Atomic {
    private final char value;

    public Char(char val) {
        this.value = val;
    }

    @Override
    public Result_Obj call3(CurProc cp, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return Char.stdResult(this.add(cp));
            }
            case "*": 
            case "mul": {
                return Char.stdResult(this.multi(cp));
            }
            case "++": 
            case "inc": {
                return Char.stdResult(this.incDec(cp, true));
            }
            case "--": 
            case "dec": {
                return Char.stdResult(this.incDec(cp, false));
            }
            case "caseUp": 
            case "upper": {
                return Char.stdResult(this.caseUp(cp));
            }
            case "caseDown": 
            case "lower": {
                return Char.stdResult(this.caseDown(cp));
            }
            case "rangeTo": {
                return this.range(cp);
            }
        }
        return null;
    }

    public Char caseDown(CurProc cp) {
        cp.pars();
        return new Char(("" + this.value).toLowerCase().charAt(0));
    }

    public Char caseUp(CurProc cp) {
        cp.pars();
        return new Char(("" + this.value).toUpperCase().charAt(0));
    }

    @Override
    public Integer compareTo2(I_AtomicValue o) {
        if (o instanceof Char) {
            return new Character(this.value).compareTo(((Char)o).gValue());
        }
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CurProc cp, ATOMIC to) {
        return Lib_AtomConv.convert(cp, ATOMIC.CHAR, to, this, this.gValue());
    }

    @Override
    public Character gValue() {
        return Character.valueOf(this.value);
    }

    @Override
    public String toDebug(CurProc cp) {
        return "'" + this.value + "'";
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CurProc cp, COMPARE m) {
        I_Object o = cp.parsExt(this, new Class[][]{{Bool.class, Char.class, Int.class, Dec.class}})[0];
        int par = Lib_Convert.getIntValue(cp, o);
        if (m == COMPARE.G) {
            return Bool.getObject(this.value > par);
        }
        if (m == COMPARE.L) {
            return Bool.getObject(this.value < par);
        }
        if (m == COMPARE.GE) {
            return Bool.getObject(this.value >= par);
        }
        if (m == COMPARE.LE) {
            return Bool.getObject(this.value <= par);
        }
        if (m == COMPARE.E) {
            return Bool.getObject(this.value == par);
        }
        if (m == COMPARE.NE) {
            return Bool.getObject(this.value != par);
        }
        throw Err.todo(new Object[]{cp, m});
    }

    private I_AtomicValue add(CurProc cp) {
        I_AtomicValue par = (I_AtomicValue)cp.pars(this, A_Atomic.class)[0];
        if (par instanceof Int) {
            return new Str("" + this.value + par.gValue());
        }
        if (par instanceof Bool) {
            return new Char((char)(this.value + (((Bool)par).gValue() != false ? (char)'\u0001' : '\u0000')));
        }
        return new Str("" + this.value + par.gValue());
    }

    private Char incDec(CurProc cp, boolean inc) {
        I_Object[] oa = cp.parsFlex(this, 0, 1, false);
        if (oa.length == 0) {
            return new Char((char)(inc ? this.value + '\u0001' : this.value - '\u0001'));
        }
        I_AtomicValue o = (I_AtomicValue)cp.parType(oa[0], (Class<?>)I_AtomicValue.class);
        int par = Lib_Convert.getIntValue(cp, o);
        char val = this.value;
        int res = inc ? val + par : val - par;
        return new Char((char)res);
    }

    private Str multi(CurProc cp) {
        Int i = (Int)cp.pars(this, Int.class)[0];
        String s = FormText.sequence(this.value, (long)i.gValue().intValue());
        return new Str(s);
    }

    private Result_Obj range(CurProc cp) {
        I_Object to = cp.parsWithBlock(this, Char.class)[0];
        return JMo_Range.createNew(cp, this, to);
    }
}

