/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data;

import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.error.Err;
import java.util.Random;

public class Lib_Random {
    private static final Random rnd = new Random();

    public static boolean getBool() {
        return rnd.nextBoolean();
    }

    public static boolean[] getBoolArray(int length) {
        Err.ifToSmall(0.0, length);
        boolean[] result = new boolean[length];
        int i = 0;
        while (i < length) {
            result[i] = rnd.nextBoolean();
            ++i;
        }
        return result;
    }

    public static boolean[] getBoolArray(int length, int amountOfTrues) {
        Err.ifToSmall(0.0, length);
        Err.ifToBig(length, amountOfTrues);
        boolean[] result = new boolean[length];
        int trues = 0;
        while (trues < amountOfTrues) {
            int pos = Lib_Random.getInt(0, length - 1);
            if (result[pos]) continue;
            result[pos] = true;
            ++trues;
        }
        return result;
    }

    public static byte[] getByteArray(int length) {
        Err.ifToSmall(0.0, length);
        byte[] result = new byte[length];
        rnd.nextBytes(result);
        return result;
    }

    public static I_Date getDate(I_Date from, I_Date to) {
        Err.ifNull(from, to);
        int diff = from.diffDays(to);
        Err.ifToSmall(1.0, diff);
        return from.getAddDays(Lib_Random.getInt(0, diff));
    }

    public static double getDouble(int min, int max) {
        return (double)Lib_Random.getInt(min, max - 1) + rnd.nextDouble();
    }

    public static int getInt() {
        return rnd.nextInt();
    }

    public static int getInt(int max) {
        return Lib_Random.getInt(0, max);
    }

    public static int getInt(int min, int max) {
        Err.ifToSmall(min, max);
        return min + rnd.nextInt(max - min + 1);
    }

    public static int[] getIntArray(int length, int min, int max) {
        Err.ifToSmall(0.0, length);
        int[] result = new int[length];
        int p = 0;
        while (p < length) {
            result[p] = Lib_Random.getInt(min, max);
            ++p;
        }
        return result;
    }

    public static int[] getIntArraySet(int from, int to) {
        if (to == from) {
            return new int[]{from};
        }
        Err.ifToSmall(from + 1, to);
        int[] result = new int[to - from + 1];
        boolean[] used = new boolean[to - from + 1];
        int z = from;
        while (z <= to) {
            boolean ok = false;
            do {
                int pos;
                if (used[pos = Lib_Random.getInt(0, result.length - 1)]) continue;
                result[pos] = z;
                used[pos] = true;
                ok = true;
            } while (!ok);
            ++z;
        }
        return result;
    }

    public static <T> I_Sequence<T> getSelection(I_Sequence<T> pool, int count, boolean doubles) {
        if (!doubles) {
            Err.ifToBig(pool.size(), count);
        }
        MList result = new MList();
        if (doubles) {
            MList pointers = new MList();
            int nr = 1;
            while (nr <= count) {
                pointers.add(Lib_Random.getInt(1, pool.size()));
                ++nr;
            }
            for (Integer i : pointers) {
                result.add(pool.get(i));
            }
        } else {
            boolean[] used = new boolean[pool.size()];
            int curLen = 0;
            while (curLen < count) {
                int rnd = Lib_Random.getInt(0, pool.size() - 1);
                if (used[rnd]) continue;
                used[rnd] = true;
                ++curLen;
            }
            int i = 1;
            while (i <= pool.size()) {
                if (used[i - 1]) {
                    result.add(pool.get(i));
                }
                ++i;
            }
        }
        return result;
    }

    public static String getString(int length, boolean upperAndLowerCase, boolean numbers) {
        return Lib_Random.getString(length, true, upperAndLowerCase, numbers, null);
    }

    public static String getString(int length, boolean lowercase, boolean uppercase, boolean numbers, String specialChars) {
        String pool = "";
        if (lowercase) {
            pool = String.valueOf(pool) + "abcdefghijklmnopqrstuvwxyz".toLowerCase();
        }
        if (uppercase) {
            pool = String.valueOf(pool) + "abcdefghijklmnopqrstuvwxyz".toUpperCase();
        }
        if (numbers) {
            pool = String.valueOf(pool) + "0123456789";
        }
        if (specialChars != null) {
            pool = String.valueOf(pool) + specialChars;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            sb.append(pool.charAt(Lib_Random.getInt(0, pool.length() - 1)));
            ++i;
        }
        return sb.toString();
    }

    public static I_List<String> getStringList(int count, int minStringLength, int maxStringLength, boolean upAndDownCase, boolean numbers) {
        MList<String> result = new MList<String>();
        int i = 1;
        while (i <= count) {
            int curLen = Lib_Random.getInt(minStringLength, maxStringLength);
            String s = Lib_Random.getString(curLen, upAndDownCase, numbers);
            result.add(s);
            ++i;
        }
        return result;
    }

    public static String getStringNumbers(int length) {
        return Lib_Random.getString(length, false, false, true, null);
    }

    public static String shuffleChars(String s) {
        int len = s.length();
        int[] rnd = Lib_Random.getIntArraySet(0, len - 1);
        char[] ca = new char[len];
        int i = 0;
        while (i < len) {
            ca[i] = s.charAt(rnd[i]);
            ++i;
        }
        return new String(ca);
    }
}

