/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.passthrough.Condition;
import org.jmo_lang.object.passthrough.While;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.tools.Lib_Parser;

public class ParseObj_ShortCutsQm
implements I_ParseObject {
    @Override
    public boolean hits(char c0, Block current, String s) {
        if (c0 != '?' || s.length() < 2) {
            return false;
        }
        switch (s.charAt(1)) {
            case '\"': 
            case '(': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    @Override
    public Group2<I_Object, String> parse(App app, Block current, String s, DebugInfo debugInfo) {
        s = s.substring(1);
        switch (s.charAt(0)) {
            case '(': {
                return this.parseCondition(app, current, s, debugInfo);
            }
            case '{': {
                return this.parseWhile(app, current, s, debugInfo);
            }
            case '\"': {
                return this.parseRegex(app, current, s, debugInfo);
            }
        }
        throw Err.invalid(s);
    }

    private Group2<I_Object, String> parseCondition(App app, Block current, String s, DebugInfo debugInfo) {
        String group = Lib_Parser.group('(', ')', s, debugInfo);
        String rem = s.substring(group.length() + 2);
        Call[] pars = Parser_Call.parseParameter(app, current, group, debugInfo);
        this.checkParCount(pars, 2, 3, debugInfo);
        return new Group2<I_Object, String>(new NonAtomic(Condition.class, pars, debugInfo), ".do" + rem);
    }

    private Group2<I_Object, String> parseWhile(App app, Block current, String s, DebugInfo debugInfo) {
        String group = Lib_Parser.group('{', '}', s, debugInfo);
        String rem = s.substring(group.length() + 2);
        Call[] pars = Parser_Call.parseParameter(app, current, group, debugInfo);
        this.checkParCount(pars, 1, 1, debugInfo);
        return new Group2<I_Object, String>(new NonAtomic(While.class, pars, debugInfo), ".do" + rem);
    }

    private Group2<I_Object, String> parseRegex(App app, Block current, String s, DebugInfo debugInfo) {
        Group2<String, Integer> g = Lib_Parser.regexGet(s, debugInfo);
        String str = g.g1();
        String rem = s.substring(g.g2() + 1);
        Call par = new Call(current, new Str(str), debugInfo);
        return new Group2<I_Object, String>(new NonAtomic(JMo_Regex.class, new Call[]{par}, debugInfo), rem);
    }

    private void checkParCount(Call[] pars, int min, int max, DebugInfo debugInfo) {
        if (!Lib_Math.isBetween(pars.length, min, max)) {
            String want = "" + min;
            if (min != max) {
                want = String.valueOf(min) + "-" + max;
            }
            throw new ParseError("Wrong Parameter-Count", "Need " + want + ", got: " + pars.length, debugInfo);
        }
    }
}

