/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.group.Group2;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.struct.App;
import org.jmo_lang.tools.Lib_StringParser;

public class ParseTimeSwitches {
    public boolean parse(App app, String s, DebugInfo debug) {
        s = s.substring(1).trim();
        Group2<String, String[]> g = this.splitLine(s, debug);
        switch (g.g1()) {
            case "exit": {
                MOut.debug("Abort parsing");
                return true;
            }
            case "debug": {
                MOut.debugDetail();
                return false;
            }
            case "setOutputFile": {
                this.parCheckCount(1, g.g2(), debug);
                String opf = this.parString(g.g2()[0], debug);
                MOut.debug("OutputFile: " + opf);
                app.setOutputFile(opf);
                return false;
            }
            case "strictBlocks": {
                app.setStrictAutoBlock();
                return false;
            }
            case "strictConsts": {
                Parser_Call.strictConsts();
                return false;
            }
            case "strictObjects": {
                Parser_Call.strictObjects();
                return false;
            }
            case "strictFunctions": {
                Parser_Call.strictFunctions();
                return false;
            }
            case "veryStrict": {
                Parser_Call.strictConsts();
                Parser_Call.strictObjects();
                Parser_Call.strictFunctions();
            }
            case "strict": {
                app.setStrictAutoBlock();
                return false;
            }
        }
        throw new ParseError("Unknown Parsetime-Command", s, debug);
    }

    private void parCheckCount(int count, String[] pa, DebugInfo debug) {
        if (count != pa.length) {
            throw new ParseError("Wrong count of arguments!", "Want " + count + ", got: " + pa.length, debug);
        }
    }

    private String parString(String s, DebugInfo debug) {
        if ((s = s.trim()).charAt(0) != '\"' || s.charAt(s.length() - 1) != '\"') {
            throw new ParseError("Invalid String!", s, debug);
        }
        return s.substring(1, s.length() - 1);
    }

    private Group2<String, String[]> splitLine(String s, DebugInfo debug) {
        int bi = s.indexOf(40);
        if (bi == -1) {
            return new Group2<String, String[]>(s, new String[0]);
        }
        String command = s.substring(0, bi).trim();
        String rem = s.substring(bi).trim();
        if (rem.charAt(rem.length() - 1) != ')') {
            throw new ParseError("Closing bracket is missing!", s, debug);
        }
        rem = rem.substring(1, rem.length() - 1);
        ArrayList<String> pa = new ArrayList<String>();
        while (rem.length() > 0) {
            Group2<String, String> result = Lib_StringParser.getNextPar(rem, debug);
            pa.add(result.g1());
            if (result.g2().equals(rem)) {
                throw new ParseError("Invalid ParseTime-Command!", s, debug);
            }
            rem = result.g2();
        }
        String[] sa = pa.toArray(new String[pa.size()]);
        return new Group2<String, String[]>(command, sa);
    }
}

