/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.convert.ConvText;
import de.mn77.base.data.filter.FilterText;
import de.mn77.base.data.form.FormText;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.lib.numbersys.Hex;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.sys.JMo_Cmd;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_StrFormat;

public class Str
extends A_Atomic {
    private final String value;

    public Str(String val) {
        Err.ifNull(val);
        this.value = val;
    }

    @Override
    public Result_Obj call3(CurProc cp, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return Str.stdResult(this.add(cp));
            }
            case "-": 
            case "sub": {
                return Str.stdResult(this.sub(cp));
            }
            case "*": 
            case "mul": {
                return Str.stdResult(this.multi(cp));
            }
            case "cut": {
                return Str.stdResult(this.cut(cp));
            }
            case "area": {
                return Str.stdResult(this.cutTo(cp));
            }
            case "to": {
                return Str.stdResult(this.to(cp));
            }
            case "left": {
                return Str.stdResult(this.left(cp));
            }
            case "right": {
                return Str.stdResult(this.right(cp));
            }
            case "from": {
                return Str.stdResult(this.from(cp));
            }
            case "explode": 
            case "/": 
            case "split": {
                return Str.stdResult(this.split(cp));
            }
            case "splitKeep": {
                return Str.stdResult(this.splitKeep(cp));
            }
            case "lines": {
                return Str.stdResult(this.lines(cp));
            }
            case "column": {
                return Str.stdResult(this.column(cp));
            }
            case "caseUp": 
            case "upper": {
                return Str.stdResult(this.caseUp(cp));
            }
            case "caseDown": 
            case "lower": {
                return Str.stdResult(this.caseDown(cp));
            }
            case "capitalize": 
            case "capital": {
                return Str.stdResult(this.capital(cp));
            }
            case "trim": {
                return Str.stdResult(this.trim(cp, true, true));
            }
            case "trimLeft": {
                return Str.stdResult(this.trim(cp, true, false));
            }
            case "trimRight": {
                return Str.stdResult(this.trim(cp, false, true));
            }
            case "length": 
            case "len": {
                return Str.stdResult(this.length(cp));
            }
            case "charAt": 
            case "get": 
            case "pos": 
            case "char": {
                return Str.stdResult(this.charAt(cp));
            }
            case "change": {
                return Str.stdResult(this.setChar(cp));
            }
            case "startsWith": {
                return Str.stdResult(this.startsWith(cp));
            }
            case "has": {
                return Str.stdResult(this.has(cp));
            }
            case "endsWith": {
                return Str.stdResult(this.endsWith(cp));
            }
            case "search": 
            case "index": {
                return Str.stdResult(this.search(cp));
            }
            case "replace": {
                return Str.stdResult(this.replace(cp));
            }
            case "match": {
                return Str.stdResult(this.match(cp));
            }
            case "alignLeft": {
                return Str.stdResult(this.align(cp, POSITION_H.LEFT));
            }
            case "alignRight": {
                return Str.stdResult(this.align(cp, POSITION_H.RIGHT));
            }
            case "alignCenter": {
                return Str.stdResult(this.align(cp, POSITION_H.CENTER));
            }
            case "fill": {
                return Str.stdResult(this.fill(cp));
            }
            case "jmo": {
                return Str.stdResult(this.exec_jmo(cp));
            }
            case "cmd": 
            case "command": {
                return Str.stdResult(this.exec_cmd(cp));
            }
            case "fromHex": 
            case "hexToInt": {
                return Str.stdResult(this.hexToInt(cp));
            }
        }
        return null;
    }

    @Override
    public Integer compareTo2(I_Atomic o) {
        if (o instanceof Str) {
            return this.value.compareTo(((Str)o).gValue());
        }
        return null;
    }

    private I_Object fill(CurProc cp) {
        I_Object[] oa = cp.parsFlex(this, 0, Integer.MAX_VALUE, false);
        int oaPos = 0;
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (pos < this.value.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(this.value, pos);
            pos += part.g2().length();
            if (!part.g1().booleanValue()) {
                sb.append(part.g2());
                continue;
            }
            sb.append(Lib_StrFormat.format(cp, part.g2(), oa[oaPos++]));
        }
        return new Str(sb.toString());
    }

    @Override
    public I_Atomic convertTo(CurProc cp, ATOMIC to) {
        return Lib_AtomConv.convert(cp, ATOMIC.STR, to, this, this.gValue());
    }

    @Override
    public String gValue() {
        return this.value;
    }

    @Override
    public String toDebug(CurProc cp) {
        return "\"" + this.value + "\"";
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    protected Bool comparsion(CurProc cp, COMPARE m) {
        I_Object o = cp.parsExt(this, new Class[][]{{Str.class, Char.class, Int.class}})[0];
        String par = Lib_Convert.getStringValue(cp, o);
        if (m == COMPARE.G) {
            return Bool.getObject(this.value.compareTo(par) > 0);
        }
        if (m == COMPARE.L) {
            return Bool.getObject(this.value.compareTo(par) < 0);
        }
        if (m == COMPARE.GE) {
            return Bool.getObject(this.value.compareTo(par) >= 0);
        }
        if (m == COMPARE.LE) {
            return Bool.getObject(this.value.compareTo(par) <= 0);
        }
        if (m == COMPARE.E) {
            return Bool.getObject(this.value.equals(par));
        }
        if (m == COMPARE.NE) {
            return Bool.getObject(!this.value.equals(par));
        }
        throw Err.todo(new Object[]{cp.call, m});
    }

    private Str add(CurProc cp) {
        I_Object par = cp.pars(this, I_Object.class)[0];
        if (par instanceof Str) {
            return new Str(String.valueOf(this.value) + ((Str)par).gValue());
        }
        if (par instanceof Int) {
            return new Str(String.valueOf(this.value) + ((Int)par).gValue());
        }
        if (par instanceof Char) {
            return new Str(String.valueOf(this.value) + ((Char)par).gValue());
        }
        return new Str(String.valueOf(this.value) + par.toString());
    }

    private Str align(CurProc cp, POSITION_H pos) {
        Int par = (Int)cp.pars(this, Int.class)[0];
        String s = FormText.width(par.gValue(), ' ', this.value, pos, false);
        return new Str(s);
    }

    private Str capital(CurProc cp) {
        cp.pars();
        String s = this.value.toLowerCase();
        String result = "";
        if (s.length() > 0) {
            result = ("" + s.charAt(0)).toUpperCase();
        }
        if (s.length() > 1) {
            result = String.valueOf(result) + s.substring(1);
        }
        return new Str(result);
    }

    private Str caseDown(CurProc cp) {
        cp.pars();
        return new Str(this.value.toLowerCase());
    }

    private Str caseUp(CurProc cp) {
        cp.pars();
        return new Str(this.value.toUpperCase());
    }

    private Char charAt(CurProc cp) {
        int pos = ((Int)cp.pars(this, Int.class)[0]).gValue();
        if (this.value.length() == 0) {
            throw new ExecError(cp, "Out of range", "String has no chars");
        }
        if (pos < 1 || pos > this.value.length()) {
            throw new ExecError(cp, "Out of range", "Could be 1-" + this.value.length() + ", got " + pos);
        }
        return new Char(this.value.charAt(pos - 1));
    }

    private Str column(CurProc cp) {
        I_Object[] oa = cp.pars(this, null, Int.class);
        if (oa[0] instanceof I_Atomic) {
            String[] sa = this.value.split(oa[0].toString());
            int pos = Lib_Convert.getIntValue(cp, oa[1]);
            return new Str(pos > sa.length ? "" : sa[pos - 1]);
        }
        throw Err.todo(oa[0].getClass());
    }

    private Str cut(CurProc cp) {
        I_Object[] pars = cp.pars(this, Int.class, Int.class);
        int from = Lib_Convert.getIntValue(cp, pars[0]) - 1;
        int to = from + Lib_Convert.getIntValue(cp, pars[1]);
        String s = this.value.substring(from, to);
        return new Str(s);
    }

    private Str cutTo(CurProc cp) {
        I_Object[] pars = cp.pars(this, Int.class, Int.class);
        int from = Lib_Convert.getIntValue(cp, pars[0]) - 1;
        int to = Lib_Convert.getIntValue(cp, pars[1]);
        Err.ifToSmall(from, to);
        String s = this.value.substring(from, to);
        return new Str(s);
    }

    private Bool endsWith(CurProc cp) {
        I_Atomic par = (I_Atomic)cp.pars(this, I_Atomic.class)[0];
        boolean b = this.value.endsWith(Lib_Convert.getStringValue(cp, par));
        return Bool.getObject(b);
    }

    private I_Object exec_cmd(CurProc cp) {
        cp.pars();
        Call c = new Call(cp.getSurrBlock(), this, cp.getDebugInfo());
        JMo_Cmd cmd = new JMo_Cmd(c);
        cmd.init(cp);
        return cmd.exec(cp, false);
    }

    private I_Object exec_jmo(CurProc cp) {
        cp.pars();
        try {
            Parser_App parser = new Parser_App();
            App app = parser.parseText(this.value);
            String result = app.exec(null);
            return new Str(result);
        }
        catch (Err_FileSys e) {
            Err.show(e, false);
            throw new ExecError(cp, "Execution-Error", e.getMessage());
        }
    }

    private Str from(CurProc cp) {
        I_Object par = cp.parsExt(this, new Class[][]{{Int.class, Char.class, Str.class}})[0];
        if (par instanceof Int) {
            Int par2 = (Int)cp.pars(this, Int.class)[0];
            int begin = par2.gValue();
            if (begin == 0) {
                throw new ExecError(cp, "String index out of range", "Possible absolute: 1-" + this.value.length() + ", got " + begin);
            }
            if (begin < 0) {
                begin = this.value.length() + begin + 1;
            }
            if (begin > this.value.length()) {
                return new Str("");
            }
            String s = this.value.substring(begin - 1);
            return new Str(s);
        }
        String delimiter = "" + ((I_Atomic)par).gValue();
        int idx = this.value.indexOf(delimiter);
        return idx >= 0 ? new Str(this.value.substring(idx)) : new Str("");
    }

    private Bool has(CurProc cp) {
        I_Atomic par = (I_Atomic)cp.pars(this, I_Atomic.class)[0];
        int index = this.value.indexOf(Lib_Convert.getStringValue(cp, par));
        return Bool.getObject(index > -1);
    }

    private I_Object hexToInt(CurProc cp) {
        cp.pars();
        int i = Hex.fromHex(this.value);
        return new Int(i);
    }

    private Str left(CurProc cp) {
        Int par = (Int)cp.pars(this, Int.class)[0];
        int to = par.gValue();
        if (to > this.value.length()) {
            return this;
        }
        Lib_Error.ifTooLow(cp, 1, to);
        String s = this.value.substring(0, to);
        return new Str(s);
    }

    private Int length(CurProc cp) {
        cp.pars();
        return new Int(this.value.length());
    }

    private JMo_List lines(CurProc cp) {
        cp.pars();
        String[] sa = this.value.split("\n");
        JMo_List list = new JMo_List();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.internalAdd(new Str(s));
            ++n2;
        }
        return list;
    }

    private Bool match(CurProc cp) {
        JMo_Regex par = (JMo_Regex)cp.pars(this, JMo_Regex.class)[0];
        return Bool.getObject(this.value.matches(par.getValue()));
    }

    private Str multi(CurProc cp) {
        Int par = (Int)cp.pars(this, Int.class)[0];
        String s = FormText.sequence(this.value, (long)par.gValue().intValue());
        return new Str(s);
    }

    private Str replace(CurProc cp) {
        I_Object[] pars = cp.parsExt(this, {I_Atomic.class, JMo_Regex.class}, {I_Atomic.class});
        String s2 = Lib_Convert.getStringValue(cp, pars[1]);
        if (pars[0] instanceof JMo_Regex) {
            String regex = ((JMo_Regex)pars[0]).getValue();
            try {
                String result = this.value.replaceAll(regex, s2);
                return new Str(result);
            }
            catch (PatternSyntaxException e) {
                throw new ExecError(cp, "Invalid Pattern Syntax", e.getMessage());
            }
        }
        String s1 = Lib_Convert.getStringValue(cp, pars[0]);
        String result = this.value.replace(s1, s2);
        return new Str(result);
    }

    private Str right(CurProc cp) {
        int len;
        Int par = (Int)cp.pars(this, Int.class)[0];
        int begin = par.gValue();
        if (begin > (len = this.value.length())) {
            return this;
        }
        Lib_Error.ifTooLow(cp, 1, begin);
        String s = this.value.substring(len - begin);
        return new Str(s);
    }

    private Int search(CurProc cp) {
        I_Object par = cp.parsExt(this, new Class[][]{{Int.class, Char.class, Str.class}})[0];
        String search = Lib_Convert.getStringValue(cp, par);
        int idx = this.value.indexOf(search);
        return idx < 0 ? new Int(-1) : new Int(idx + 1);
    }

    private Str setChar(CurProc cp) {
        I_Object[] oa = cp.parsExt(this, {Int.class}, {Char.class, Str.class});
        int pos = Lib_Convert.getIntValue(cp, oa[0]);
        if (pos < 1 || pos > this.value.length()) {
            throw new ExecError(cp, "String index out of range", "Possible 1-" + this.value.length() + ", got " + pos);
        }
        I_Object o = oa[1];
        String n = ((I_Atomic)o).toString();
        String l = pos == 1 ? "" : this.value.substring(0, pos - 1);
        String r = pos == this.value.length() ? "" : this.value.substring(pos);
        return new Str(String.valueOf(l) + n + r);
    }

    private JMo_List split(CurProc cp) {
        I_Object par = cp.parsExt(this, new Class[][]{{Char.class, Int.class, Str.class, JMo_Regex.class}})[0];
        if (par instanceof JMo_Regex) {
            String regex = par.toString();
            String[] sa = this.value.split(regex);
            JMo_List list = new JMo_List();
            String[] stringArray = sa;
            int n = sa.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                list.internalAdd(new Str(s));
                ++n2;
            }
            return list;
        }
        if (par instanceof Int) {
            int count = Lib_Convert.getIntValue(cp, par);
            Lib_Error.ifTooLow(cp, 1, count);
            JMo_List list = new JMo_List();
            String str = this.value;
            int start = 0;
            while (start < str.length()) {
                list.internalAdd(new Str(str.substring(start, Math.min(str.length(), start + count))));
                start += count;
            }
            return list;
        }
        String delimiter = "" + ((I_Atomic)par).gValue();
        I_List<String> sl = ConvText.toList(delimiter, this.value);
        JMo_List list = new JMo_List();
        for (String s : sl) {
            list.internalAdd(new Str(s));
        }
        return list;
    }

    private JMo_List splitKeep(CurProc cp) {
        I_Object o = cp.parsExt(this, new Class[][]{{I_Atomic.class, JMo_List.class}})[0];
        TypeTable2<String, Boolean> tab = null;
        if (o instanceof I_Atomic) {
            tab = ConvText.splitToTable(this.value, o.toString());
        } else if (o instanceof JMo_List) {
            JMo_List delimiters = (JMo_List)o;
            ArrayList<String> al = new ArrayList<String>();
            for (I_Object delimiter : delimiters.getInternalObject()) {
                if (!(delimiter instanceof I_Atomic)) {
                    throw new ExecError(cp, "Non-Atomic Delimiter", "Got: " + Lib_Convert.typeName(delimiter.getClass(), delimiter));
                }
                al.add(Lib_Convert.getStringValue(cp, delimiter));
            }
            tab = ConvText.splitToTable(this.value, al.toArray(new String[al.size()]));
        } else {
            throw Err.todo(o);
        }
        I_List<String> data = tab.getCol1();
        JMo_List list = new JMo_List();
        for (String s : data) {
            list.internalAdd(new Str(s));
        }
        return list;
    }

    private Bool startsWith(CurProc cp) {
        I_Atomic par = (I_Atomic)cp.pars(this, I_Atomic.class)[0];
        boolean b = this.value.startsWith(Lib_Convert.getStringValue(cp, par));
        return Bool.getObject(b);
    }

    private Str sub(CurProc cp) {
        Char c = (Char)cp.pars(this, Char.class)[0];
        return new Str(this.value.replace("" + c.gValue(), ""));
    }

    private Str to(CurProc cp) {
        I_Object par = cp.parsExt(this, new Class[][]{{Int.class, Char.class, Str.class}})[0];
        if (par instanceof Int) {
            int to = Lib_Convert.getIntValue(cp, par);
            if (to == 0 || Math.abs(to) > this.value.length()) {
                throw new ExecError(cp, "String index out of range", "Possible absolute: 1-" + this.value.length() + ", got " + to);
            }
            if (to < 0) {
                to = this.value.length() + to + 1;
            }
            String s = this.value.substring(0, to);
            return new Str(s);
        }
        String delimiter = "" + ((I_Atomic)par).gValue();
        int idx = this.value.indexOf(delimiter);
        return idx >= 0 ? new Str(this.value.substring(0, idx + delimiter.length())) : this;
    }

    private Str trim(CurProc cp, boolean left, boolean right) {
        cp.pars();
        String s = FilterText.trim(this.value, new char[]{' ', '\t', '\r', '\f', '\n'}, left, right);
        return new Str(s);
    }
}

