/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.terminal;

import de.mn77.base.data.struct.HistoryList;
import de.mn77.lib.terminal.COLOR_BG;
import de.mn77.lib.terminal.COLOR_FG;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class MTerminal {
    private final HistoryList<String> history = new HistoryList();
    private MODE currentMode;
    private Reader input;
    private final InputStream inputStream = new FileInputStream(FileDescriptor.in);
    private PrintWriter output;

    public MTerminal() throws UnsupportedEncodingException {
        this.callStty(MODE.RAW);
        this.input = new InputStreamReader(this.inputStream, "UTF-8");
        this.output = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        this.output.flush();
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    private void callStty(MODE mode) {
        String[] cmdRaw = new String[]{"/bin/sh", "-c", "stty -ignbrk -brkint -parmrk -istrip -inlcr -igncr -icrnl -ixon -opost -echo -echonl -icanon -isig -iexten -parenb cs8 min 1 < /dev/tty"};
        String[] cmdCooked = new String[]{"/bin/sh", "-c", "stty sane cooked < /dev/tty"};
        try {
            Process process = mode == MODE.RAW ? Runtime.getRuntime().exec(cmdRaw) : Runtime.getRuntime().exec(cmdCooked);
            this.currentMode = mode;
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            String line = in.readLine();
            if (line != null && line.length() > 0) {
                System.err.println("WEIRD?! Normal output from stty: " + line);
            }
            while (true) {
                BufferedReader err;
                if ((line = (err = new BufferedReader(new InputStreamReader(process.getErrorStream(), "UTF-8"))).readLine()) != null && line.length() > 0) {
                    System.err.println("Error output from stty: " + line);
                }
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            int rc = process.exitValue();
            if (rc != 0) {
                System.err.println("stty returned error code: " + rc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeTerminal() {
        if (this.currentMode == MODE.RAW) {
            this.callStty(MODE.COOKED);
        } else {
            try {
                if (this.input != null) {
                    this.input.close();
                    this.input = null;
                }
                if (this.output != null) {
                    this.output.close();
                    this.output = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public String readln() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void print(Object ... oa) {
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Enum c;
            Object o = objectArray[n2];
            if (o instanceof String) {
                this.output.print((String)o);
            } else if (o instanceof COLOR_FG) {
                c = (COLOR_FG)((Object)o);
                this.output.print(((COLOR_FG)c).color);
            } else if (o instanceof COLOR_BG) {
                c = (COLOR_BG)((Object)o);
                this.output.print(((COLOR_BG)c).color);
            } else {
                this.output.print(o.toString());
            }
            ++n2;
        }
        this.output.flush();
    }

    private static enum MODE {
        COOKED,
        RAW;

    }
}

