/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version;

import de.mn77.base.data.group.Group3;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.base.version.A_VersionDataExt;
import de.mn77.base.version.I_VersionData;
import de.mn77.base.version.VERSIONTYPE;
import de.mn77.base.version.VersionFormatter;

public class VersionData_ABC
extends A_VersionDataExt {
    private Integer medium;

    public static I_VersionData fromOld(String[] sa) {
        Integer big = Integer.parseInt(sa[0]);
        Integer medium = Integer.parseInt(sa[1]);
        Integer small = Integer.parseInt(sa[2]);
        Long build = Long.parseLong(sa[3]);
        MDateTime time = new MDateTime(String.valueOf(sa[4]) + " " + sa[5]);
        MOut.exit(big, medium, small, build, time);
        return new VersionData_ABC(big, medium, small, build, time);
    }

    public VersionData_ABC(int big, int medium, int small) {
        super(big, VERSIONTYPE.RELEASE, small);
        this.medium = medium;
    }

    public VersionData_ABC(int big, int medium, int small, Long build, I_DateTime zeit) {
        this(big, medium, small);
        this.update(build, zeit);
        throw Err.todo("!!! Testen !!!");
    }

    public VersionData_ABC(I_DateTime time, Long build, String[] sa) {
        super(time, build, sa);
        this.medium = Integer.parseInt(sa[1]);
    }

    protected Integer getMedium() {
        return this.medium;
    }

    @Override
    public String toString() {
        return this.iToString(true);
    }

    public String toString_BuildDate() {
        return this.getBuild() + " - " + this.getTime().getDate();
    }

    public String toString_Short() {
        return this.iToString(false);
    }

    public String toString_Dots() {
        return this.iToString(true);
    }

    @Override
    public String toFormat(String format) {
        return new VersionFormatter().format(this, format);
    }

    @Override
    public Object[] toFileData() {
        return new Object[]{this.getNr(), this.medium, this.getFixnr()};
    }

    @Override
    public char getDataSign() {
        return 'b';
    }

    @Override
    protected Group3<Integer, VERSIONTYPE, Integer> update(String[] sa) {
        this.medium = Integer.parseInt(sa[1]);
        return new Group3<Integer, VERSIONTYPE, Integer>(Integer.parseInt(sa[0]), VERSIONTYPE.RELEASE, Integer.parseInt(sa[2]));
    }

    private String iToString(boolean withBuild) {
        return this.getNr() + "." + this.medium + (this.getFixnr() == 0 ? "" : "." + this.getFixnr()) + (withBuild ? " (Build: " + this.getBuild() + " - " + this.getTime() + ")" : "");
    }
}

