/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.data.filter.FilterText;
import de.mn77.base.data.search.SearchText;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.A_FileSys_Item;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.Lib_FileSys;
import de.mn77.base.sys.file.MDir;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class MFile
extends A_FileSys_Item
implements I_File {
    public MFile(File f) {
        Err.ifNull(f);
        this.file = f;
    }

    public MFile(String path) {
        this(new File(path));
    }

    @Override
    public FileOutputStream write() throws Err_FileSys {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw Err.wrap(e, "File not found");
        }
    }

    @Override
    public FileInputStream read() throws Err_FileSys {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw Err.wrap(e, "File not found");
        }
    }

    @Override
    public String getSuffix() {
        return Lib_FileSys.getSuffix(this.file);
    }

    @Override
    public void setSuffix(String s) {
        String suffix = this.getSuffix();
        String path = this.getPathAbsolute();
        path = FilterText.cut(0 - suffix.length() - 1, true, path);
        path = path.replaceFirst("\\.+$", "");
        this.file = new File(String.valueOf(path) + "." + s);
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getNameWithoutSuffix() {
        return this.file.getName().replaceFirst("^(.*)\\..*$", "$1");
    }

    @Override
    public void execDefault() throws Err_FileSys {
        Lib_FileSys.start(this.getFile());
    }

    @Override
    public void delete() throws Err_FileSys {
        if (this.file.exists() && !this.file.delete()) {
            Err.fsFailed("Can't delete File", this.file);
        }
    }

    @Override
    public void rename(String newName) throws Err_FileSys {
        String tv = Sys.getSeperatorDir();
        I_Sequence<Integer> res = SearchText.positions(newName, tv);
        if (res.size() > 0) {
            throw Err.invalid("No Path allowed!", newName);
        }
        Err.ifNull(newName);
        File newFile = this.getDirectory().dirNew(newName).getFile();
        try {
            Files.move(this.file.toPath(), newFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw Err.wrap(e, "Rename", this.file.toString(), newFile.toString());
        }
        this.file = newFile;
    }

    @Override
    public void move(I_Directory to) throws Err_FileSys {
        Lib_FileSys.move(this.getFile(), to.dirNew(this.getName()).getFile());
    }

    @Override
    public void copy(I_Directory to) throws Err_FileSys {
        Lib_FileSys.copyFile(this.getFile(), to.dirNew(this.getName()).getFile());
    }

    @Override
    public void copy(I_File to) throws Err_FileSys {
        Lib_FileSys.copyFile(this.getFile(), to.getFile());
    }

    @Override
    public void create() throws Err_FileSys {
        boolean ok = false;
        try {
            ok = this.file.createNewFile();
        }
        catch (IOException e) {
            Err.wrap(e, "Error while creating the file");
            return;
        }
        if (!ok) {
            Err.fsAccess("File maybe already exists", this.getPathAbsolute());
        }
    }

    @Override
    public String getDirectoryName() {
        return this.file.getParent();
    }

    @Override
    public I_Directory getDirectory() {
        try {
            return new MDir(this.file.getParent());
        }
        catch (Err_FileSys e) {
            throw Err.impossible(e);
        }
    }

    @Override
    public boolean isDirectory() {
        return false;
    }
}

