/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.keypot;

import de.mn77.base.data.struct.keypot.A_KeyPot;
import de.mn77.base.data.struct.keypot.I_KeyPotList;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.set.I_Set;
import de.mn77.base.data.struct.set.MSet;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;

public class KeyPotList<TA, TB>
extends A_KeyPot<TA, TB>
implements I_KeyPotList<TA, TB> {
    private final I_Set<I_List<TB>> pots = new MSet<I_List<TB>>();

    @Override
    public I_List<TB> get(TA key) {
        Integer pos = this.keys.searchPosition(key);
        Err.ifNull(pos);
        return (I_List)this.pots.get(pos);
    }

    @Override
    public I_List<TB> get(TA key, I_List<TB> ifMissing) {
        Integer pos = this.keys.searchPosition(key);
        if (pos == null) {
            return ifMissing;
        }
        return (I_List)this.pots.get(pos);
    }

    @Override
    public I_KeyPotList<TA, TB> addAllItems(TA key, TB ... objects) {
        TB[] TBArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            TB o = TBArray[n2];
            this.add(key, o);
            ++n2;
        }
        return this;
    }

    @Override
    public void add(TA key, TB object) {
        Integer pos = this.keys.searchPosition(key);
        if (pos == null) {
            this.keys.add(key);
            MList neu = new MList();
            this.pots.add(neu);
            pos = this.keys.searchPosition(key);
        }
        ((I_List)this.pots.get(pos)).add(object);
    }

    @Override
    public void remove(TA key) {
        Integer pos = this.keys.searchPosition(key);
        if (pos == null) {
            Err.invalid(key, "Invalid Key");
        }
        this.keys.remove(pos);
        this.pots.remove(pos);
    }

    @Override
    public TB remove(TA key, TB object) {
        I_List pot;
        Integer pos = this.keys.searchPosition(key);
        if (pos == null) {
            Err.invalid(key, "Invalid Key");
        }
        if ((pot = (I_List)this.pots.get(pos)).contains(object)) {
            pot.remove(object);
        } else {
            Err.invalid(object, "Unknown Object");
        }
        return object;
    }

    @Override
    public I_List<TB> removeAllItems(TA key) {
        Integer pos = this.keys.searchPosition(key);
        if (pos == null) {
            Err.invalid(key, "Invalid Key");
        }
        I_List result = (I_List)((I_List)this.pots.get(pos)).copy();
        while (((I_List)this.pots.get(pos)).size() > 0) {
            ((I_List)this.pots.get(pos)).remove(1);
        }
        return result;
    }

    @Override
    public void exchange(int row_a, int row_b) {
        Err.ifEqual(row_a, 0);
        Err.ifEqual(row_b, 0);
        Err.ifOutOfBounds(1.0, this.size(), Math.abs(row_a));
        Err.ifOutOfBounds(1.0, this.size(), Math.abs(row_b));
        if (row_a == row_b) {
            MOut.warnung("Exchange of " + row_a + " and " + row_b + " not necessary!");
            return;
        }
        this.keys.exchange(row_a, row_b);
        this.pots.exchange(row_a, row_b);
    }

    @Override
    public void sortLike(int[] order) {
        this.keys.sort(order);
        this.pots.sort(order);
    }

    @Override
    public Object get(int col, int row) {
        if (col == 1) {
            return this.keys.get(row);
        }
        if (col == 2) {
            return this.pots.get(row);
        }
        throw Err.invalid(col);
    }

    @Override
    public void describe() {
        MOut.debug(this);
    }

    @Override
    public I_KeyPotList<TA, TB> copy() {
        throw Err.todo(new Object[0]);
    }
}

