/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.error.Err;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.Nil;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.JMo_Java;

public class Lib_Java {
    public static boolean comparable(Class<?> java, Class<?> jmo) {
        if (jmo == Str.class && java == String.class) {
            return true;
        }
        if (jmo == Int.class && (java == Integer.TYPE || java == Integer.class)) {
            return true;
        }
        if (jmo == JMo_Byte.class && (java == Byte.TYPE || java == Byte.class)) {
            return true;
        }
        if (jmo == JMo_Short.class && (java == Short.TYPE || java == Short.class)) {
            return true;
        }
        if (jmo == JMo_Long.class && (java == Long.TYPE || java == Long.class)) {
            return true;
        }
        if (jmo == JMo_Float.class && (java == Float.TYPE || java == Float.class)) {
            return true;
        }
        if (jmo == Dec.class && (java == Double.TYPE || java == Double.class)) {
            return true;
        }
        if (jmo == Char.class && (java == Character.TYPE || java == Character.class)) {
            return true;
        }
        if (jmo == Bool.class && (java == Boolean.TYPE || java == Boolean.class)) {
            return true;
        }
        if (jmo == JMo_Java.class) {
            Err.todo(jmo, java);
        }
        return false;
    }

    public static I_Object javaToJmo(Object java) {
        if (java == null) {
            return Nil.NIL;
        }
        if (java instanceof Integer) {
            return new Int((Integer)java);
        }
        if (java instanceof String) {
            return new Str((String)java);
        }
        throw Err.todo(java.getClass().getSimpleName(), java);
    }

    public static Object jmoToJava(I_Object jmo) {
        if (jmo instanceof I_Atomic) {
            return ((I_Atomic)jmo).gValue();
        }
        throw Err.todo(jmo.getClass().getSimpleName(), jmo);
    }
}

