/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.data.struct.set.MSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Condition;
import org.jmo_lang.object.JMo_For;
import org.jmo_lang.object.JMo_Group;
import org.jmo_lang.object.JMo_If;
import org.jmo_lang.object.JMo_Random;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.JMo_Table;
import org.jmo_lang.object.JMo_Timer;
import org.jmo_lang.object.JMo_While;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.object.filesys.JMo_Path;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.list.JMo_Map;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.object.sys.JMo_Input;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.JMo_Java;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.hints.HintManager;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.ClassFinder;
import org.jmo_lang.tools.Lib_Convert;

public class ObjectManager {
    public static I_Object get(App app, String name, Call[] pars, DebugInfo debugInfo) {
        String[] stringArray = ATOMIC.ATOMIC_TYPENAMES;
        int n = ATOMIC.ATOMIC_TYPENAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            if (name.equals(r)) {
                throw ObjectManager.atomic(name, debugInfo);
            }
            ++n2;
        }
        Class<? extends I_Object> c = ObjectManager.iAssignType(name);
        if (c != null) {
            return new NonAtomic(c, pars, debugInfo);
        }
        if (name.charAt(0) == 'J' && name.startsWith("Java")) {
            if (name.length() > 5 && name.charAt(4) == '_') {
                return new JMo_Java(name.substring(5), pars, debugInfo);
            }
            if (pars.length < 1) {
                throw new ParseError("Missing Parameter for Java-Class", "Par-Length: 0", debugInfo);
            }
            Call[] parscopy = new Call[pars.length - 1];
            if (pars.length > 1) {
                System.arraycopy(pars, 1, parscopy, 0, pars.length - 1);
            }
            return new JMo_Java(pars[0], parscopy, debugInfo);
        }
        c = ObjectManager.getClass(name);
        if (c != null) {
            return new NonAtomic(c, pars, debugInfo);
        }
        Type t = app.getType().getType(name);
        if (t == null) {
            throw new ParseError("Unknown Type", name, debugInfo);
        }
        return new Instance(app, t, pars);
    }

    public static Class<? extends I_Object> getClass(String search) {
        return ObjectManager.getClassFinder().get("JMo_" + search);
    }

    public static ArrayList<String> search(HintManager hm, String search) {
        MSet<String> set = new MSet<String>();
        Collection<Class<? extends I_Object>> l = ObjectManager.getClassFinder().getAll();
        for (Class<? extends I_Object> c : l) {
            String name = Lib_Convert.typeName(c, null);
            if (!name.startsWith(search)) continue;
            set.add(name);
        }
        Collection<String> hints = hm.searchTypes(search);
        set.addIfUnknown(hints);
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(set);
        return result;
    }

    private static Class<? extends I_Object> iAssignType(String name) {
        switch (name) {
            case "Group": {
                return JMo_Group.class;
            }
            case "If": {
                return JMo_If.class;
            }
            case "Condition": {
                return JMo_Condition.class;
            }
            case "For": {
                return JMo_For.class;
            }
            case "While": {
                return JMo_While.class;
            }
            case "Range": {
                return JMo_Range.class;
            }
            case "List": {
                return JMo_List.class;
            }
            case "Map": {
                return JMo_Map.class;
            }
            case "Input": {
                return JMo_Input.class;
            }
            case "Random": {
                return JMo_Random.class;
            }
            case "Timer": {
                return JMo_Timer.class;
            }
            case "File": {
                return JMo_File.class;
            }
            case "Dir": {
                return JMo_Dir.class;
            }
            case "Path": {
                return JMo_Path.class;
            }
            case "Table": {
                return JMo_Table.class;
            }
        }
        return null;
    }

    private static ErrorBaseDebug atomic(String type, DebugInfo debugInfo) {
        return new ParseError("Atomic types cannot created via typename!", type, debugInfo);
    }

    private static ClassFinder getClassFinder() {
        return ClassFinder.getInstance("org.jmo_lang");
    }
}

