/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.error.Err;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;

public class Dec
extends A_Number
implements I_Decimal {
    private final double value;

    public Dec(double val) {
        this.value = Lib_Math.normalize(val, 10);
    }

    @Override
    public Result_Obj call4(CurProc cp, String method) {
        switch (method) {
            case "rangeTo": {
                return this.range(cp);
            }
            case "roundDown": 
            case "floor": {
                return Dec.stdResult(this.floor(cp));
            }
            case "roof": 
            case "roundUp": {
                return Dec.stdResult(this.roof(cp));
            }
            case "round": {
                return Dec.stdResult(this.round(cp));
            }
        }
        return null;
    }

    @Override
    public int compareTo(I_Object o) {
        if (o instanceof Dec) {
            return new Double(this.value).compareTo(((Dec)o).gValue());
        }
        return super.compareTo(o);
    }

    @Override
    public I_Atomic convertTo(CurProc cp, ATOMIC to) {
        return Lib_AtomConv.convert(cp, ATOMIC.DEC, to, this, this.gValue());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Dec && ((Dec)obj).gValue() == this.value;
    }

    @Override
    public Double gValue() {
        return this.value;
    }

    @Override
    public String toDebug(CurProc cp) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CurProc cp, COMPARE m) {
        I_Object o = cp.parsExt(this, new Class[][]{{Bool.class, Char.class, Int.class, Dec.class}})[0];
        Double par = Lib_Convert.getDoubleValue(cp, o);
        if (m == COMPARE.G) {
            return Bool.getObject(this.value > par);
        }
        if (m == COMPARE.L) {
            return Bool.getObject(this.value < par);
        }
        if (m == COMPARE.GE) {
            return Bool.getObject(this.value >= par);
        }
        if (m == COMPARE.LE) {
            return Bool.getObject(this.value <= par);
        }
        if (m == COMPARE.E) {
            return Bool.getObject(this.value == par);
        }
        if (m == COMPARE.NE) {
            return Bool.getObject(this.value != par);
        }
        throw Err.todo(new Object[]{cp, m});
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP0 op) {
        switch (op) {
            case INC: {
                return new Dec(this.value + 1.0);
            }
            case DEC: {
                return new Dec(this.value - 1.0);
            }
            case NEG: {
                return new Dec(-this.value);
            }
            case ABS: {
                return new Dec(Math.abs(this.value));
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op));
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP01 op, I_Object[] pars) {
        if (pars.length == 0) {
            switch (op) {
                case POW: {
                    return new Dec(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
                case SQRR: {
                    return new Int((int)Math.round(Math.sqrt(this.value)));
                }
            }
        } else {
            A_Number parn = (A_Number)cp.parType(pars[0], (Class<?>)A_Number.class);
            double par = Lib_Convert.getDoubleValue(cp, parn);
            switch (op) {
                case POW: {
                    return new Dec(Math.pow(this.value, par));
                }
                case SQR: {
                    return new Dec(Math.exp(Math.log(this.value) / par));
                }
                case SQRR: {
                    return new Int((int)Math.round(Math.exp(Math.log(this.value) / par)));
                }
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + pars.length);
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP1 op, A_Number parn) {
        double val = this.value;
        double par = Lib_Convert.getDoubleValue(cp, parn);
        switch (op) {
            case ADD: {
                return new Dec(val + par);
            }
            case SUB: {
                return new Dec(val - par);
            }
            case MUL: {
                return new Dec(val * par);
            }
            case DIV: {
                if (par == 0.0) {
                    throw new ExecError(cp, "Division by zero", val + "/" + par);
                }
                return new Dec(val / par);
            }
            case DIVR: {
                if (par == 0.0) {
                    throw new ExecError(cp, "Division by zero", val + "/" + par);
                }
                return new Int((int)Math.round(val / par));
            }
            case MOD: {
                return new Dec(val % par);
            }
            case AND: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) & Double.doubleToRawLongBits(par)));
            }
            case OR: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) | Double.doubleToRawLongBits(par)));
            }
            case XOR: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) ^ Double.doubleToRawLongBits(par)));
            }
            case SHL: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) << (int)Double.doubleToRawLongBits(par)));
            }
            case SHR: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) >> (int)Double.doubleToRawLongBits(par)));
            }
            case LOG: {
                return new Dec(Math.log(this.value) / Math.log(par));
            }
            case LOGR: {
                return new Int((int)Math.round(Math.log(this.value) / Math.log(par)));
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", (Object)((Object)op) + " " + parn.getClass().getSimpleName());
    }

    @Override
    protected Str number_opStr(CurProc cp, A_Number.NOP1 op, A_Atomic p) {
        String val = "" + this.value;
        String par = Lib_Convert.getStringValue(cp, p);
        switch (op) {
            case ADD: {
                return new Str(String.valueOf(val) + par);
            }
            case MUL: {
                throw new ExecError(cp, "Wrong Type to multiply a Char or Str", "Got " + this.getClass().getSimpleName() + ", please use Int");
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", (Object)((Object)op) + " " + p.getClass().getSimpleName());
    }

    private Int floor(CurProc cp) {
        cp.pars();
        return new Int((int)Math.floor(this.value));
    }

    private Result_Obj range(CurProc cp) {
        I_Object to = cp.parsWithBlockExt(this, new Class[][]{{Int.class, Dec.class}})[0];
        return JMo_Range.createNew(cp, this, to);
    }

    private Int roof(CurProc cp) {
        cp.pars();
        return new Int((int)Math.ceil(this.value));
    }

    private I_Atomic round(CurProc cp) {
        I_Object[] pars = cp.parsFlex(this, 0, 1, false);
        switch (pars.length) {
            case 0: {
                return new Int((int)Math.round(this.value));
            }
            case 1: {
                int i = Lib_Convert.getIntValue(cp, pars[0]);
                if (i < 0 || i > 10) {
                    throw new ExecError(cp, "Wrong Parameter", "Got " + i + ", allowed = 0-10");
                }
                return new Dec(Lib_Math.round(this.value, i));
            }
        }
        throw Err.impossible(new Object[0]);
    }
}

