/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.csv;

import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.Lib_TextFile;
import java.io.File;

public class CSV_TableFile {
    private final File file;
    private char separator_field = (char)34;
    private char separator_col = (char)44;
    private String separator_line = "\n";

    public CSV_TableFile(File f) {
        Err.ifNull(f);
        this.file = f;
    }

    public CSV_TableFile(String file) {
        this(new File(file));
    }

    public CSV_TableFile(I_File file) {
        this(file.getFile());
    }

    public CSV_TableFile setSeparatorLine(String s) {
        this.separator_line = s;
        return this;
    }

    public CSV_TableFile setSeparatorCol(char c) {
        this.separator_col = c;
        return this;
    }

    public CSV_TableFile setSeparatorField(char c) {
        this.separator_field = c;
        return this;
    }

    public CSV_TableFile write(I_Table<String> table) throws Err_FileSys {
        Err.ifNull(table);
        try {
            if (this.file.exists()) {
                this.file.delete();
            }
            MList<String> data = new MList<String>();
            int row = 1;
            while (row <= table.size()) {
                String line = "";
                int col = 1;
                while (col <= table.getWidth()) {
                    String feld = (String)table.getCol(col).get(row);
                    if (feld == null) {
                        feld = "";
                    }
                    if ((feld = feld.replaceAll("" + this.separator_field, "" + this.separator_field + this.separator_field)).length() > 0) {
                        feld = String.valueOf(this.separator_field) + feld + this.separator_field;
                    }
                    line = String.valueOf(line) + feld + (col < table.getWidth() ? "" + this.separator_col : "");
                    ++col;
                }
                data.add(line);
                ++row;
            }
            Lib_TextFile.set(this.file, data, true);
        }
        catch (Exception err) {
            throw Err.fsAccess(err);
        }
        return this;
    }

    public void write(I_List<String> head, I_Table<String> table) throws Err_FileSys {
        MTable<String> tab = new MTable<String>(head.size());
        tab.add((I_Sequence<String>)head);
        for (I_Sequence i_Sequence : table) {
            tab.add(i_Sequence);
        }
        this.write(tab);
    }

    public I_Table<String> get() throws Err_FileSys {
        return this.iGet(true, true);
    }

    public I_Table<String> getWithoutFirstLine() throws Err_FileSys {
        return this.iGet(false, true);
    }

    public I_List<String> getFirstLine() throws Err_FileSys {
        return this.iGet(true, false).getRow(1);
    }

    public char getSeparatorCol() {
        return this.separator_col;
    }

    public char getSeparatorField() {
        return this.separator_field;
    }

    public String getSeparatorLine() {
        return this.separator_line;
    }

    private I_Table<String> iGet(boolean first, boolean other) throws Err_FileSys {
        MTable<String> result = null;
        I_List<String> lines = Lib_TextFile.readLines(this.file, true);
        int line_nr = 1;
        while (line_nr <= lines.size()) {
            String line = (String)lines.get(line_nr);
            String[] sa = this.iConvert(line);
            if (result == null) {
                result = new MTable<String>(sa.length);
            }
            if (sa.length != 0 && (first && line_nr == 1 || other && line_nr > 1)) {
                result.add(sa);
            }
            ++line_nr;
        }
        return result;
    }

    private String[] iConvert(String text) {
        MList<String> result = new MList<String>();
        boolean open = false;
        boolean double_tf = false;
        String field = "";
        int p = 0;
        while (p < text.length()) {
            boolean latest;
            char c = text.charAt(p);
            boolean bl = latest = p == text.length() - 1;
            if (c == this.separator_field) {
                if (double_tf) {
                    double_tf = false;
                    field = String.valueOf(field) + c;
                } else if (open) {
                    if (latest || text.charAt(p + 1) != this.separator_field) {
                        open = false;
                    } else {
                        double_tf = true;
                    }
                } else {
                    open = true;
                }
            } else if (!open && c == this.separator_col) {
                result.add(field);
                field = "";
                if (latest) {
                    result.add("");
                }
            } else {
                field = String.valueOf(field) + c;
            }
            ++p;
        }
        if (field.length() > 0) {
            result.add(field);
        }
        return result.toArray(String.class);
    }
}

