/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.A_FileSys_Item;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.I_FileSys_Item;
import de.mn77.base.sys.file.Lib_FileSys;
import de.mn77.base.sys.file.MFile;
import java.io.File;

public class MDir
extends A_FileSys_Item
implements I_Directory {
    public MDir(Object dir) throws Err_FileSys {
        this(dir, false);
    }

    public MDir(Object dir, boolean createIfMissing) throws Err_FileSys {
        Err.ifNull(dir);
        if (createIfMissing) {
            if (dir instanceof String) {
                Lib_FileSys.createPathStructure((String)dir);
            } else {
                Err.todo(dir);
            }
        }
        if (dir instanceof String) {
            this.file = new File((String)dir);
        } else if (dir instanceof File) {
            this.file = (File)dir;
        } else {
            Err.invalid("Unknown Type", dir.getClass().getName(), dir);
        }
        if (!this.file.exists()) {
            Err.invalid("Directory doesn't exist", this.file.getAbsolutePath());
        }
        if (!this.file.isDirectory()) {
            Err.invalid("Folder expected, file found", this.file.getAbsolutePath());
        }
    }

    public static boolean exists(String name) throws Err_FileSys {
        File f = new File(name);
        return f.exists();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public I_File fileFlex(String filename) {
        String newPath = String.valueOf(this.file.getAbsolutePath()) + Sys.getSeperatorDir() + filename;
        File f = new File(newPath);
        return new MFile(f);
    }

    @Override
    public I_File fileFlex(String name, String suffix) {
        return this.fileFlex(String.valueOf(name) + "." + suffix);
    }

    @Override
    public I_File fileNew(String name, String suffix) throws Err_FileSys {
        return this.fileNew(String.valueOf(name) + "." + suffix);
    }

    @Override
    public I_File fileNew(String filename) throws Err_FileSys {
        String newPath = String.valueOf(this.file.getAbsolutePath()) + Sys.getSeperatorDir() + filename;
        File f = new File(newPath);
        Err.fsIfExist(f);
        return new MFile(f);
    }

    @Override
    public I_File file(String filename) throws Err_FileSys {
        String newPath = String.valueOf(this.file.getAbsolutePath()) + Sys.getSeperatorDir() + filename;
        File f = new File(newPath);
        Err.fsIfMissing(f);
        return new MFile(f);
    }

    @Override
    public I_File file(String filename, String suffix) throws Err_FileSys {
        return this.file(String.valueOf(filename) + "." + suffix);
    }

    @Override
    public I_Directory dirFlex(String name) throws Err_FileSys {
        String newPath = String.valueOf(this.file.getAbsolutePath()) + "/" + name;
        File f = new File(newPath);
        if (!f.exists() && !f.mkdir()) {
            throw Err.fsFailed("Can't create directory", f);
        }
        try {
            return new MDir(f);
        }
        catch (Err_FileSys e) {
            e.addDetail("Can't create directory");
            throw e;
        }
    }

    @Override
    public I_Directory dirNew(String name) throws Err_FileSys {
        String newPath = String.valueOf(this.file.getAbsolutePath()) + "/" + name;
        File f = new File(newPath);
        Err.fsIfExist(f);
        if (!f.mkdir()) {
            throw Err.fsFailed("Can't create directory", f);
        }
        return new MDir(f);
    }

    @Override
    public I_Directory dir(String name) throws Err_FileSys {
        String newPath = String.valueOf(this.file.getAbsolutePath()) + "/" + name;
        File f = new File(newPath);
        Err.fsIfMissing(f);
        return new MDir(f);
    }

    @Override
    public void setReadOnly() throws Err_FileSys {
        boolean b = this.file.setReadOnly();
        if (!b) {
            Err.fsAccess(this.file);
        }
    }

    @Override
    public I_List<I_FileSys_Item> content() {
        File[] files;
        MList<I_FileSys_Item> result = new MList<I_FileSys_Item>();
        File[] fileArray = files = this.file.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                result.add(new MFile(file));
            } else {
                try {
                    result.add(new MDir(file));
                }
                catch (Err_FileSys e) {
                    throw Err.impossible(e);
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public I_List<I_File> contentFiles() {
        File[] files;
        MList<I_File> result = new MList<I_File>();
        File[] fileArray = files = this.file.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                result.add(new MFile(file));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public I_List<I_File> contentFiles(boolean recursive) {
        return this.contentFiles(recursive, true);
    }

    @Override
    public I_List<I_File> contentFiles(boolean recursive, boolean hiddenDirsToo) {
        return recursive ? this.iContentFiles(new MList<I_File>(), this, hiddenDirsToo) : this.contentFiles();
    }

    @Override
    public I_List<I_File> contentFiles(String regex) {
        File[] files;
        MList<I_File> result = new MList<I_File>();
        File[] fileArray = files = this.file.listFiles(pathname -> pathname.getName().matches(regex));
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                result.add(new MFile(file));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public I_List<I_File> contentFilesWithSuffix(String ... filter) {
        return this.contentFilesWithSuffix(false, filter);
    }

    @Override
    public I_List<I_File> contentFilesWithSuffix(boolean recursive, String ... filter) {
        Err.ifToSmall(1.0, filter.length);
        String[] stringArray = filter;
        int n = filter.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Err.ifNull(s);
            ++n2;
        }
        return recursive ? this.iContentFileWithSuffix(new MList<I_File>(), this, filter) : this.iContentFileWithSuffix(filter);
    }

    @Override
    public I_List<I_Directory> contentDirs() {
        MList<I_Directory> result = new MList<I_Directory>();
        File[] files = this.file.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File datei = fileArray[n2];
                if (datei.isDirectory()) {
                    try {
                        result.add(new MDir(datei));
                    }
                    catch (Err_FileSys e) {
                        throw Err.impossible(e);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public I_List<I_Directory> contentDirs(String regex) {
        File[] files;
        MList<I_Directory> result = new MList<I_Directory>();
        File[] fileArray = files = this.file.listFiles(pathname -> pathname.isDirectory() && pathname.getName().matches(regex));
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                result.add(new MDir(file));
            }
            catch (Err_FileSys e) {
                throw Err.impossible(e);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean knows(String name) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public boolean knowsFile(String name) {
        return this.contentFiles(name).size() > 0;
    }

    @Override
    public boolean knowsDir(String name) {
        return this.contentDirs(name).size() > 0;
    }

    @Override
    public String getDirectoryName() {
        throw Err.todo(new Object[0]);
    }

    @Override
    public void delete() throws Err_FileSys {
        if (this.file.exists()) {
            MOut.debug("Delete Directory: " + this.getPathAbsolute());
            if (!this.file.delete()) {
                Err.fsFailed("Deletion of Directory failed", this.file);
            }
        }
    }

    @Override
    public void rename(String newName) throws Err_FileSys {
        String pathNew = String.valueOf(this.getDirectory().getPathAbsolute()) + Sys.getSeperatorDir() + newName;
        File fileNew = new File(pathNew);
        boolean ok = Lib_FileSys.rename(this.getFile(), fileNew);
        if (!ok) {
            throw Err.fsFailed("Rename failed", this.file, newName, pathNew);
        }
        this.file = fileNew;
    }

    @Override
    public String getNameWithoutSuffix() {
        return this.file.getName();
    }

    @Override
    public String getName() {
        return this.getNameWithoutSuffix();
    }

    @Override
    public I_Directory getDirectory() {
        try {
            return new MDir(this.file.getParent());
        }
        catch (Err_FileSys e) {
            throw Err.impossible(e);
        }
    }

    private I_List<I_File> iContentFiles(I_List<I_File> addToThis, I_Directory dir, boolean hiddenDirsToo) {
        if (!hiddenDirsToo && (dir.getFile().isHidden() || dir.getNameWithoutSuffix().startsWith("."))) {
            return addToThis;
        }
        addToThis.addAll(dir.contentFiles());
        I_List<I_Directory> content = dir.contentDirs();
        for (I_Directory o : content) {
            this.iContentFiles(addToThis, o, hiddenDirsToo);
        }
        return addToThis;
    }

    private I_List<I_File> iContentFileWithSuffix(I_List<I_File> addToThis, I_Directory dir, String[] filter) {
        addToThis.addAll(dir.contentFilesWithSuffix(filter));
        I_List<I_Directory> content = dir.contentDirs();
        for (I_Directory o : content) {
            this.iContentFileWithSuffix(addToThis, o, filter);
        }
        return addToThis;
    }

    private I_List<I_File> iContentFileWithSuffix(String[] filter) {
        File[] files;
        Err.ifToSmall(1.0, filter.length);
        String regex = "^.*(";
        int i = 0;
        while (i < filter.length) {
            if (i > 0) {
                regex = String.valueOf(regex) + "|";
            }
            regex = String.valueOf(regex) + "\\." + filter[i].toLowerCase();
            ++i;
        }
        String regex2 = regex = String.valueOf(regex) + ")$";
        MList<I_File> result = new MList<I_File>();
        File[] fileArray = files = this.file.listFiles(pathname -> pathname.getName().toLowerCase().matches(regex2) && pathname.isFile());
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            result.add(new MFile(file));
            ++n2;
        }
        return result;
    }
}

