/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.cmd;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.cmd.SysCmd_Data;
import de.mn77.base.sys.file.I_Directory;
import java.io.IOException;

public class SysCmd {
    public static void start(String cmd) throws Exception {
        SysCmd.start(cmd, "", false);
    }

    public static void start(String cmd, boolean wait) throws Exception {
        SysCmd.start(cmd, "", wait);
    }

    public static void start(String cmd, String param) throws Exception {
        SysCmd.start(null, cmd, param, false);
    }

    public static void start(String cmd, String param, boolean wait) throws Exception {
        SysCmd.start(null, cmd, param, wait);
    }

    public static void start(I_Directory startDir, String cmd, String param, boolean wait) throws Exception {
        SysCmd_Data data = new SysCmd_Data();
        data.startDir.set(startDir);
        data.command.set(cmd);
        data.parameter.set(param);
        data.wait.set(wait);
        new SysCmd().start(data);
    }

    public void start(SysCmd_Data data) throws Err_Exception {
        Err.ifNull(data, data.command.get());
        String cmd = data.command.get();
        if (data.parameter.get() != null && data.parameter.get().length() > 0) {
            cmd = String.valueOf(cmd) + " " + data.parameter.get();
        }
        if (data.startDir.get() != null) {
            cmd = "cd " + data.startDir.get() + ";" + cmd;
        }
        try {
            if (!Sys.isLinux()) {
                Err.todo(new Object[0]);
            }
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd});
            if (data.streamOutput.get() != null) {
                Lib_Stream.connect(p.getInputStream(), data.streamOutput.get(), true, true);
            }
            if (data.streamError.get() != null) {
                Lib_Stream.connect(p.getErrorStream(), data.streamError.get(), true, true);
            }
            if (data.streamInput.get() != null) {
                Lib_Stream.connect(data.streamInput.get(), p.getOutputStream(), true, true);
            }
            if (data.wait.get() != null && data.wait.get().booleanValue()) {
                try {
                    data.result.set(p.waitFor());
                }
                catch (InterruptedException e1) {
                    data.result.set(Integer.MIN_VALUE);
                    Err.wrap(e1, "External Process was not clean executed!", data);
                }
            }
        }
        catch (IOException e) {
            data.result.set(Integer.MIN_VALUE);
            Err.wrap(e, "External Process was not clean executed!", data);
        }
        if (data.result.get() != null && data.result.get() != 0) {
            throw Err.newRuntime("Command could not be started!", data);
        }
    }
}

