/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys;

import de.mn77.base.data.form.FormDateTime;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.MFileSys;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Log {
    private static Log singletonMain = null;
    private I_File target = null;

    public static void main(String[] args) {
        try {
            Log.newSingleton(MFileSys.temp(), "testlog", false);
            Log.write("Hallo");
            Log.write("Ok");
        }
        catch (Err_Exception e) {
            Err.show(e, true);
        }
    }

    public Log(I_Directory dir, String filename) throws Err_Exception {
        this.target = dir.fileFlex(String.valueOf(filename) + "_" + FormDateTime.zuTextDS(new MDateTime()), "txt");
    }

    public static void newSingleton(I_Directory dir, String filename, boolean productive) throws Err_Exception {
        if (Log.getActive()) {
            throw Err.invalid("Log bereits initialisiert!");
        }
        try {
            singletonMain = new Log(dir, "log");
        }
        catch (Err_Exception e) {
            Err.show(e, false);
            return;
        }
        if (productive) {
            MOut.debugNo();
        }
        MOut.useLog();
    }

    public static void newSingleton(I_Directory dir, boolean productive) throws Err_Exception {
        Log.newSingleton(dir, "log", productive);
    }

    public static void newSingleton(String appName, boolean productive) throws Err_Exception {
        try {
            I_Directory dir = MFileSys.dirAppData_Nitsche(appName).dirFlex("Logs");
            Log.newSingleton(dir, productive);
        }
        catch (Err_FileSys e) {
            Err.show(e, false);
            return;
        }
    }

    public static boolean getActive() {
        return singletonMain != null;
    }

    public static void write(String text) {
        singletonMain.iWrite(text);
    }

    private void iWrite(String text) {
        block12: {
            RandomAccessFile raf = null;
            try {
                try {
                    raf = new RandomAccessFile(this.target.getFile(), "rw");
                    raf.seek(raf.length());
                    raf.writeBytes(new MDateTime() + "\n" + text + "\n");
                }
                catch (Exception e) {
                    Err.show(e, false);
                    if (raf == null) break block12;
                    try {
                        raf.close();
                    }
                    catch (IOException e2) {
                        Err.show(e2, false);
                    }
                }
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        Err.show(e, false);
                    }
                }
            }
        }
    }
}

