/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type.datetime;

import de.mn77.base.data.constant.DATE;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.format.FORM_DATE;
import de.mn77.base.error.Err;
import java.util.GregorianCalendar;

public class Lib_DateTime {
    private static final int YEAR_CENTURY_CHANGE_FELT_DIFF = 20;

    public static final boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public static final int daysOfYear(int year) {
        return Lib_DateTime.isLeapYear(year) ? 366 : 365;
    }

    public static final int daysOfMonth(int year, int month) {
        Err.ifOutOfBounds(1.0, 12.0, month);
        return month == 2 && Lib_DateTime.isLeapYear(year) ? 29 : DATE.DAYS_OF_MONTH_MIN[month - 1];
    }

    public static final String nameDayOfWeek(int day) {
        Err.ifOutOfBounds(0.0, 7.0, day);
        return day == 0 ? DATE.NAME_DAYOFWEEK_DE[6] : DATE.NAME_DAYOFWEEK_DE[day - 1];
    }

    public static Integer parseMonth(String month) {
        month = month.toLowerCase();
        int n = 1;
        while (n <= 12) {
            String de = DATE.NAME_MONTH_DE[n - 1].toLowerCase();
            String en = DATE.NAME_MONTH_EN[n - 1].toLowerCase();
            if (month.equals(de)) {
                return n;
            }
            if (month.equals(de.substring(0, 3))) {
                return n;
            }
            if (month.equals(en)) {
                return n;
            }
            if (month.equals(en.substring(0, 3))) {
                return n;
            }
            ++n;
        }
        return null;
    }

    public static final int yearShortToLong(String yy) {
        Err.ifNull(yy);
        Err.ifNot(2, yy.length());
        int result = Integer.parseInt(yy);
        int current = Integer.parseInt(new MDate().toString(new Object[]{FORM_DATE.YEAR_2}));
        String curCentStr = new MDate().toString(new Object[]{FORM_DATE.YEAR_4});
        int curCent = Integer.parseInt(curCentStr.substring(0, 2)) * 100;
        return result + (result < (current += 20) ? curCent : curCent - 100);
    }

    public static String toText(long seconds) {
        int h = (int)(seconds / 3600L);
        int m = (int)((seconds -= (long)(h * 3600)) / 60L);
        int s = (int)(seconds -= (long)(m * 60));
        String text = String.valueOf(FormNumber.width(2, h, false)) + ":" + FormNumber.width(2, m, false) + ":" + FormNumber.width(2, s, false);
        return text;
    }

    public static long toMilliSec(int year, int month, int day) {
        return new GregorianCalendar(year, month - 1, day).getTimeInMillis();
    }

    public static long toMilliSec(int year, int month, int day, int std, int min, int sek, int msek) {
        long result = new GregorianCalendar(year, month - 1, day).getTimeInMillis();
        return result + Lib_DateTime.toMilliSec(std, min, sek, msek);
    }

    public static long addDays(int year, int month, int day, int to_add) {
        GregorianCalendar gc = new GregorianCalendar(year, month - 1, day);
        gc.add(5, to_add);
        return gc.getTimeInMillis();
    }

    public static long addDays(int year, int month, int day, int hour, int min, int sec, int msec, int add_msec) {
        GregorianCalendar gc = new GregorianCalendar(year, month - 1, day);
        gc.add(5, add_msec);
        return gc.getTimeInMillis() + Lib_DateTime.toMilliSec(hour, min, sec, msec);
    }

    public static long toMilliSec(int hour, int min, int sec, int msec) {
        long result = msec;
        result += (long)sec * 1000L;
        result += (long)min * 1000L * 60L;
        return result += (long)hour * 1000L * 60L * 60L;
    }
}

