/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.error.Err;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.Nil;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_Convert;

public class Lib_AtomConv {
    public static I_Atomic convert(CurProc cp, ATOMIC from, ATOMIC to, I_Object so, Object o) {
        switch (from) {
            case BOOL: {
                return Lib_AtomConv.convertBool(cp, to, so, o);
            }
            case CHAR: {
                return Lib_AtomConv.convertChar(cp, to, so, o);
            }
            case BYTE: {
                return Lib_AtomConv.convertByte(cp, to, so, o);
            }
            case SHORT: {
                return Lib_AtomConv.convertShort(cp, to, so, o);
            }
            case INT: {
                return Lib_AtomConv.convertInt(cp, to, so, o);
            }
            case LONG: {
                return Lib_AtomConv.convertLong(cp, to, so, o);
            }
            case FLOAT: {
                return Lib_AtomConv.convertFloat(cp, to, so, o);
            }
            case DEC: {
                return Lib_AtomConv.convertDec(cp, to, so, o);
            }
            case STR: {
                return Lib_AtomConv.convertStr(cp, to, so, o);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    public static I_Atomic convert(CurProc cp, ATOMIC to, I_Object so) {
        if (so instanceof Bool) {
            return Lib_AtomConv.convert(cp, ATOMIC.BOOL, to, so, ((I_Atomic)so).gValue());
        }
        if (so instanceof Char) {
            return Lib_AtomConv.convert(cp, ATOMIC.CHAR, to, so, ((I_Atomic)so).gValue());
        }
        if (so instanceof JMo_Byte) {
            return Lib_AtomConv.convert(cp, ATOMIC.BYTE, to, so, ((I_Atomic)so).gValue());
        }
        if (so instanceof JMo_Short) {
            return Lib_AtomConv.convert(cp, ATOMIC.SHORT, to, so, ((I_Atomic)so).gValue());
        }
        if (so instanceof Int) {
            return Lib_AtomConv.convert(cp, ATOMIC.INT, to, so, ((I_Atomic)so).gValue());
        }
        if (so instanceof JMo_Long) {
            return Lib_AtomConv.convert(cp, ATOMIC.LONG, to, so, ((I_Atomic)so).gValue());
        }
        if (so instanceof JMo_Float) {
            return Lib_AtomConv.convert(cp, ATOMIC.FLOAT, to, so, ((I_Atomic)so).gValue());
        }
        if (so instanceof Dec) {
            return Lib_AtomConv.convert(cp, ATOMIC.DEC, to, so, ((I_Atomic)so).gValue());
        }
        if (so instanceof Str) {
            return Lib_AtomConv.convert(cp, ATOMIC.STR, to, so, ((I_Atomic)so).gValue());
        }
        throw Err.invalid(new Object[]{to, so});
    }

    private static I_Atomic convertBool(CurProc cp, ATOMIC to, I_Object so, Object o) {
        boolean v = (Boolean)o;
        switch (to) {
            case BOOL: {
                return (Bool)so;
            }
            case CHAR: {
                return new Char(v ? (char)'1' : '0');
            }
            case BYTE: {
                return new JMo_Byte(v ? (byte)1 : 0);
            }
            case SHORT: {
                return new JMo_Short(v ? (short)1 : 0);
            }
            case INT: {
                return new Int(v ? 1 : 0);
            }
            case LONG: {
                return new JMo_Long(v ? 1 : 0);
            }
            case FLOAT: {
                return new JMo_Float(v ? 1 : 0);
            }
            case DEC: {
                return new Dec(v ? 1 : 0);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertByte(CurProc cp, ATOMIC to, I_Object so, Object o) {
        byte v = (Byte)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0);
            }
            case CHAR: {
                return new Char(("" + v).charAt(0));
            }
            case BYTE: {
                return (JMo_Byte)so;
            }
            case SHORT: {
                return new JMo_Short(v);
            }
            case INT: {
                return new Int(v);
            }
            case LONG: {
                return new JMo_Long(v);
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertChar(CurProc cp, ATOMIC to, I_Object so, Object o) {
        char v = ((Character)o).charValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v == '1');
            }
            case CHAR: {
                return (Char)so;
            }
            case BYTE: {
                return new JMo_Byte(Byte.parseByte("" + (byte)v));
            }
            case SHORT: {
                return new JMo_Short(Short.parseShort("" + (short)v));
            }
            case INT: {
                return new Int(Integer.parseInt("" + v));
            }
            case LONG: {
                return new JMo_Long(Long.parseLong("" + (long)v));
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertDec(CurProc cp, ATOMIC to, I_Object so, Object o) {
        double v = (Double)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0.0);
            }
            case CHAR: {
                return new Char(("" + v).charAt(0));
            }
            case BYTE: {
                return new JMo_Byte((byte)Math.round(v));
            }
            case SHORT: {
                return new JMo_Short((short)Math.round(v));
            }
            case INT: {
                return new Int((int)Math.round(v));
            }
            case LONG: {
                return new JMo_Long(Math.round(v));
            }
            case FLOAT: {
                return new JMo_Float((float)v);
            }
            case DEC: {
                return (Dec)so;
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertFloat(CurProc cp, ATOMIC to, I_Object so, Object o) {
        float v = ((Float)o).floatValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0.0f);
            }
            case CHAR: {
                return new Char(("" + v).charAt(0));
            }
            case BYTE: {
                return new JMo_Byte((byte)Math.round(v));
            }
            case SHORT: {
                return new JMo_Short((short)Math.round(v));
            }
            case INT: {
                return new Int(Math.round(v));
            }
            case LONG: {
                return new JMo_Long(Math.round(v));
            }
            case FLOAT: {
                return (JMo_Float)so;
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertInt(CurProc cp, ATOMIC to, I_Object so, Object o) {
        int v = (Integer)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0);
            }
            case CHAR: {
                return new Char(("" + v).charAt(0));
            }
            case BYTE: {
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                return new JMo_Short((short)v);
            }
            case INT: {
                return (Int)so;
            }
            case LONG: {
                return new JMo_Long(v);
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertLong(CurProc cp, ATOMIC to, I_Object so, Object o) {
        long v = (Long)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0L);
            }
            case CHAR: {
                return new Char(("" + v).charAt(0));
            }
            case BYTE: {
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                return new JMo_Short((short)v);
            }
            case INT: {
                return new Int((int)v);
            }
            case LONG: {
                return (JMo_Long)so;
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertShort(CurProc cp, ATOMIC to, I_Object so, Object o) {
        short v = (Short)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0);
            }
            case CHAR: {
                return new Char(("" + v).charAt(0));
            }
            case BYTE: {
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                return (JMo_Short)so;
            }
            case INT: {
                return new Int(v);
            }
            case LONG: {
                return new JMo_Long(v);
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertStr(CurProc cp, ATOMIC to, I_Object so, Object o) {
        String v = (String)o;
        try {
            switch (to) {
                case BOOL: {
                    String lv = v.toLowerCase();
                    if (lv.length() == 0 || lv.equals("false") || lv.equals("0")) {
                        return Bool.FALSE;
                    }
                    return Bool.TRUE;
                }
                case CHAR: {
                    return new Char(v.length() == 0 ? (char)'\u0000' : v.charAt(0));
                }
                case BYTE: {
                    return new JMo_Byte(Byte.parseByte(v));
                }
                case SHORT: {
                    return new JMo_Short(Short.parseShort(v));
                }
                case INT: {
                    return new Int(Integer.parseInt(v));
                }
                case LONG: {
                    return new JMo_Long(Long.parseLong(v));
                }
                case FLOAT: {
                    String s2 = v.replace(',', '.');
                    return new Dec(Float.parseFloat(s2));
                }
                case DEC: {
                    String s3 = v.replace(',', '.');
                    return new Dec(Double.parseDouble(s3));
                }
                case STR: {
                    return (Str)so;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new ExecError(cp, "Can't convert this String to " + to.name + ".", v);
        }
        throw Err.impossible(new Object[0]);
    }

    public static I_Object getDefaultValue(String type) {
        if (type == null) {
            return Nil.NIL;
        }
        if (type.endsWith("?")) {
            return Nil.NIL;
        }
        if (type.equals(Lib_Convert.typeName(Bool.class, null))) {
            return Bool.FALSE;
        }
        if (type.equals(Lib_Convert.typeName(Char.class, null))) {
            return new Char(' ');
        }
        if (type.equals(Lib_Convert.typeName(JMo_Byte.class, null))) {
            return new JMo_Byte(0);
        }
        if (type.equals(Lib_Convert.typeName(JMo_Short.class, null))) {
            return new JMo_Short(0);
        }
        if (type.equals(Lib_Convert.typeName(Int.class, null))) {
            return new Int(0);
        }
        if (type.equals(Lib_Convert.typeName(JMo_Long.class, null))) {
            return new JMo_Long(0L);
        }
        if (type.equals(Lib_Convert.typeName(JMo_Float.class, null))) {
            return new JMo_Float(0.0f);
        }
        if (type.equals(Lib_Convert.typeName(Dec.class, null))) {
            return new Dec(0.0);
        }
        if (type.equals(Lib_Convert.typeName(Str.class, null))) {
            return new Str("");
        }
        return Nil.NIL;
    }
}

