/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.test;

import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.debug.DEBUG_LEVEL;
import de.mn77.base.debug.Stopwatch;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.cmd.SysCmd;
import de.mn77.base.sys.cmd.SysCmd_Data;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.MDir;
import de.mn77.base.sys.file.MFile;
import de.mn77.base.sys.file.MFileSys;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;

public class TestAll {
    private static final boolean STOP_AT_FAIL = true;
    private static final boolean HINTS = false;
    private static final DEBUG_LEVEL DEBUG = DEBUG_LEVEL.NO;

    public static void main(String[] args) {
        MOut.setDebug(DEBUG);
        try {
            Stopwatch clock = new Stopwatch();
            TestAll.start();
            clock.print();
        }
        catch (Throwable t) {
            Err.show(t, true);
        }
    }

    private static void dir(String s) throws Exception {
        MDir o = new MDir(s);
        I_List<I_File> list = o.contentFiles();
        list.sort(new int[0]);
        MOut.debug(list);
        Stopwatch uhr = new Stopwatch();
        for (I_File d : list) {
            TestAll.test(d.getPathAbsolute());
        }
        MOut.text("\nTesttime: " + uhr.gStringMillisec());
    }

    private static void start() throws Exception {
        String testdir = MFileSys.current().dir("test").dir("auto").getPathAbsolute();
        TestAll.dir(testdir);
    }

    private static void test(String s) throws Exception {
        MFile datei = new MFile(s);
        MFile testfile = new MFile("/tmp/jmo-test.txt");
        if (testfile.exists()) {
            testfile.delete();
        }
        MOut.text("===== " + s);
        Parser_App parser = new Parser_App();
        App app = parser.parseText("_JMO.setOutputFile(\"/tmp/jmo-test.txt\")");
        parser.parseFile(app, datei);
        app.exec(null);
        I_File soll = datei.getDirectory().dirFlex("output").fileFlex(datei.getName(), "txt");
        if (!soll.exists() && testfile.exists()) {
            testfile.copy(soll);
        }
        if (!testfile.exists()) {
            return;
        }
        String befehl = "diff " + soll.getPathAbsolute() + " " + testfile.getPathAbsolute();
        SysCmd_Data sysInfo = new SysCmd_Data();
        sysInfo.startDir.set(testfile.getDirectory());
        sysInfo.command.set(befehl);
        sysInfo.wait.set(true);
        boolean ok = true;
        try {
            new SysCmd().start(sysInfo);
        }
        catch (Exception f) {
            ok = false;
        }
        if (ok) {
            MOut.text("Check: OK");
        } else {
            MOut.text("Check: FAIL");
            String befehl2 = "kdiff3 " + soll.getPathAbsolute() + " " + testfile.getPathAbsolute();
            SysCmd_Data sysInfo2 = new SysCmd_Data();
            sysInfo2.startDir.set(testfile.getDirectory());
            sysInfo2.command.set(befehl2);
            sysInfo2.wait.set(false);
            try {
                new SysCmd().start(sysInfo2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }
}

