/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.Nil;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Error;

public class Function
extends A_Object {
    private final String name;
    private final Block block;
    private final FunctionPar[] pars;
    private final String returnType;
    private final Type typ;

    public Function(Type typ, String name, FunctionPar[] pars, String returnType) {
        this.typ = typ;
        this.name = name;
        this.block = new Block(typ, this, typ.getBlock());
        this.pars = pars;
        if (pars != null) {
            FunctionPar[] functionParArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionPar par = functionParArray[n2];
                if (par.isConst) {
                    this.block.gConstManager().create(par.name);
                } else {
                    this.block.gVarManager().create(par.name);
                }
                ++n2;
            }
        }
        this.returnType = returnType;
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "return": 
            case "<": 
            case "=": {
                I_Object[] pars = cp.parsFlex(this, 0, 1, false);
                Nil par = pars.length == 0 ? Nil.NIL : pars[0];
                return Function.stdResult(new Return(Return.LEVEL.RETURN, par));
            }
        }
        return null;
    }

    @Override
    public int compareTo(I_Object o) {
        throw Lib_Error.notAllowed(null);
    }

    @Override
    public void describe(CurProc cp, int depth) {
        this.block.describe(cp, depth);
    }

    public Block gBlock() {
        return this.block;
    }

    public String gName() {
        return this.name;
    }

    public String gReturnType() {
        return this.returnType;
    }

    public Type gType() {
        return this.typ;
    }

    public FunctionPar[] gVars() {
        return this.pars;
    }

    @Override
    public String toDebug(CurProc cp) {
        return "Function: " + this.name + "\n" + this.block.toDebug(cp);
    }

    @Override
    public String toString() {
        return "Function: " + this.name + "\n" + this.block.toString();
    }
}

