/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.pseudo.I_ObjToReplace;
import org.jmo_lang.object.pseudo.Loop;
import org.jmo_lang.object.pseudo.MC_BLOCK;
import org.jmo_lang.object.pseudo.MC_EACH;
import org.jmo_lang.object.pseudo.MC_STREAM;
import org.jmo_lang.object.pseudo.MagicConst;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.I_Next;
import org.jmo_lang.struct.hints.HintManager;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;

public class Call
implements I_Next {
    private final DebugInfo debugInfo;
    private final I_Object obj;
    private final String met;
    private final Call[] par_calls;
    private final Block surrounding;
    private Block ownBlock = null;
    private Call stream = null;
    private Call lastCall = null;

    public Call(Block surrBlock, I_Object obj, DebugInfo debugInfo) {
        this(surrBlock, obj, null, null, debugInfo);
    }

    public Call(Block surrBlock, I_Object obj, String met, Call[] pars, DebugInfo debugInfo) {
        if (met != null && met.length() == 0) {
            Err.invalid(met);
        }
        Err.ifNull(surrBlock);
        this.surrounding = surrBlock;
        this.obj = obj;
        this.met = met;
        this.par_calls = pars;
        this.debugInfo = debugInfo;
    }

    public void describe(CurProc cp, int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + this.toDebug(cp));
        if (cp.parResultIsSet()) {
            I_Object[] i_ObjectArray = cp.parResultGet(this);
            int n = i_ObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object par = i_ObjectArray[n2];
                par.describe(cp, left + 1);
                ++n2;
            }
        }
        if (this.ownBlock != null) {
            this.ownBlock.describe(cp, left + 1);
        }
    }

    @Override
    public final I_Object exec(CurProc cp, I_Object streamIt) {
        return this.exec(cp, streamIt, null);
    }

    public final I_Object exec(CurProc cpOld, I_Object streamIt, I_Object eachIt) {
        I_Object with;
        I_Object res = null;
        I_Object objNew = this.obj;
        CurProc cpNew = cpOld.copyCall(this, false);
        if (objNew != null && !(objNew instanceof MC_BLOCK)) {
            if (objNew instanceof NonAtomic) {
                objNew = ((NonAtomic)objNew).create();
            }
            objNew.init(cpNew);
        }
        I_Object i_Object = with = objNew != null ? objNew : streamIt;
        if (with instanceof I_ObjToReplace) {
            if (with instanceof MC_BLOCK) {
                with = this.surrounding.gIT();
            }
            if (objNew instanceof MC_STREAM) {
                with = streamIt;
            }
            if (with instanceof MC_EACH) {
                if (eachIt == null) {
                    throw new ParseError(cpOld, "Invalid call!", "This function currently doesn't support _EACH.");
                }
                with = eachIt;
            }
            if (with instanceof MagicConst) {
                with = ((MagicConst)with).get(cpNew);
            }
        }
        if (with == null) {
            Err.invalid("No Object to work with! With/IT is null", this.toDebug(cpOld), objNew, streamIt, this.getSurrounding().gIT(), cpOld.getDebugInfo());
        }
        boolean looped = false;
        if (this.par_calls != null) {
            Call[] callArray = this.par_calls;
            int n = this.par_calls.length;
            int n2 = 0;
            while (n2 < n) {
                Call c = callArray[n2];
                if (c.obj instanceof Loop) {
                    looped = true;
                    break;
                }
                ++n2;
            }
        }
        if (!looped) {
            res = with.call(cpNew);
        } else {
            Call[] pars = this.par_calls;
            int len = pars.length;
            I_Object streamIt2 = with;
            I_Object o = this.obj != null ? this.obj : streamIt2;
            I_Object[] parsResult = new I_Object[len];
            int pp = 0;
            while (pp < pars.length) {
                parsResult[pp] = pars[pp].exec(cpNew, o);
                ++pp;
            }
            boolean run = true;
            while (run) {
                I_Object[] parsTemp = new I_Object[len];
                boolean nextSet = false;
                run = false;
                boolean hasItems = true;
                int p = len - 1;
                while (p >= 0) {
                    parsTemp[p] = parsResult[p];
                    if (parsTemp[p] instanceof Loop) {
                        Loop loop = (Loop)parsResult[p];
                        loop.exec(cpOld, this.surrounding, o);
                        if (!nextSet) {
                            hasItems = loop.hasNext();
                            if (loop.hasNext()) {
                                parsTemp[p] = loop.getNext();
                                nextSet = true;
                            } else {
                                loop.reset();
                                parsTemp[p] = loop.getNext();
                            }
                        } else {
                            I_Object current = loop.getCurrent();
                            if (current == null) {
                                current = loop.getNext();
                            }
                            parsTemp[p] = current;
                        }
                        if (loop.hasNext()) {
                            run = true;
                        }
                    }
                    --p;
                }
                CurProc cpNew2 = cpNew.copyCall(this, false);
                cpNew2.parResultSet(this, parsTemp, false);
                I_Object i_Object2 = res = hasItems ? with.call(cpNew2) : with;
            }
        }
        if (cpOld.getApp().genHints) {
            HintManager hints = cpOld.getApp().gHintManager();
            if (objNew == null) {
                MOut.text("Object is null: " + this.met);
            } else if (this.met != null && objNew.getClass() != Instance.class) {
                hints.addType(objNew.getTypeName(), objNew.getTypes());
                if (!this.getSurrounding().gType().getFunctions().knows(this.met)) {
                    hints.addCall(cpOld, res.getTypeName(), this.met, cpOld.parResultGet(this));
                }
            }
        }
        return res;
    }

    public I_Object execStream(CurProc cp, I_Object streamIt) {
        CurProc cpNew = cp.copyCall(cp.call, false);
        I_Object result = this.stream.exec(cpNew, streamIt);
        cp.parResultSet(this, new I_Object[]{result}, true);
        return result;
    }

    public Block getCallBlock() {
        return this.ownBlock;
    }

    public DebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    public I_Object getInternObject() {
        return this.obj;
    }

    public Call[] getInternPars() {
        return this.par_calls;
    }

    public Call getLastParCall() {
        return this.lastCall;
    }

    public String getMethod() {
        return this.met;
    }

    public I_Object[] getPars(CurProc cp, I_Object streamIt, I_Object eachIt) {
        if (!cp.parResultIsSet()) {
            int len = this.par_calls == null ? 0 : this.par_calls.length;
            I_Object[] parsTemp = new I_Object[len];
            if (len > 0) {
                int pp = 0;
                while (pp < len) {
                    I_Object o = this.obj != null ? this.obj : streamIt;
                    parsTemp[pp] = this.par_calls[pp].exec(cp, o, eachIt);
                    ++pp;
                }
            }
            if (!cp.parResultIsSet()) {
                cp.parResultSet(this, parsTemp, false);
            }
        }
        return cp.parResultGet(this);
    }

    public Call getStream() {
        return this.stream;
    }

    public Block getSurrounding() {
        return this.surrounding;
    }

    public void setBlock(Block b) {
        if (this.ownBlock != null) {
            Err.invalid(this.ownBlock, b);
        }
        this.ownBlock = b;
    }

    public void setLastCall(Call c) {
        this.lastCall = c;
    }

    public void setStream(Call c) {
        if (this.stream != null || c == null) {
            Err.invalid(this.stream, c);
        }
        this.stream = c;
    }

    @Override
    public String toDebug(CurProc cp) {
        return this.iToDebug(cp, false, false);
    }

    public String toString() {
        String o = this.obj == null ? "" : this.obj.toString();
        String m = this.met == null ? "" : "." + this.met;
        String p = Lib_Output.toString(this.par_calls);
        if (p.length() != 0) {
            p = "(" + p + ")";
        }
        return this.met == null ? String.valueOf(o) + p : String.valueOf(o) + m + p;
    }

    private String iToDebug(CurProc cp, boolean withStream, boolean full) {
        String s;
        String o = this.obj == null ? "" : this.obj.toDebug(cp);
        String m = this.met == null ? "" : "." + this.met;
        String p = Lib_Output.toDebug(cp, this.par_calls);
        if (p.length() != 0) {
            p = "(" + p + ")";
        }
        String b = this.ownBlock == null ? "" : "{" + this.ownBlock.toDebug(cp) + "}";
        String string = s = this.stream == null ? "" : this.stream.toDebug(cp);
        if (this.met == null && this.ownBlock == null && this.stream == null) {
            return String.valueOf(o) + p;
        }
        return withStream ? String.valueOf(o) + m + p + b + s : String.valueOf(o) + m + p + b;
    }
}

