/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type;

import de.mn77.base.data.I_Comparable;
import de.mn77.base.error.Err;

public class Lib_Compare {
    public static boolean isEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (o1 instanceof I_Comparable) {
            return ((I_Comparable)o1).isEqual(o2);
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2) == 0;
        }
        return o1.equals(o2);
    }

    public static boolean isSmaller(Object base, Object than) {
        return Lib_Compare.isGreater(than, base);
    }

    public static boolean isGreater(Object base, Object than) {
        if (Lib_Compare.isEqual(base, than)) {
            return false;
        }
        if (base != null && than == null) {
            return true;
        }
        if (base == null && than != null) {
            return false;
        }
        if (base instanceof String && than instanceof String) {
            return Lib_Compare.isGreater_DE((String)base, (String)than);
        }
        if (base instanceof I_Comparable && than instanceof I_Comparable) {
            return ((I_Comparable)base).isGreater(than);
        }
        if (base.getClass() == than.getClass() && base instanceof Comparable && than instanceof Comparable) {
            return ((Comparable)base).compareTo(than) > 0;
        }
        throw Err.todo("Currently not comparable", base, than);
    }

    public static boolean isGreater_DE(String s1, String s2) {
        Err.ifNull(s1, s2);
        Boolean result = Lib_Compare.iIsGreater_DE(s1, s2);
        return result != null ? result : s1.compareTo(s2) < 0;
    }

    private static char iUmlautKorrektur(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 97 + 65);
        }
        if (c == '\u00c4' || c == '\u00e4') {
            return 'A';
        }
        if (c == '\u00d6' || c == '\u00f6') {
            return 'O';
        }
        if (c == '\u00dc' || c == '\u00fc') {
            return 'U';
        }
        return c;
    }

    private static Boolean iIsGreater_DE(String s1, String s2) {
        Err.ifNull(s1, s2);
        int min = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < min) {
            char v2;
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            char v1 = Lib_Compare.iUmlautKorrektur(c1);
            if (v1 != (v2 = Lib_Compare.iUmlautKorrektur(c2))) {
                if (v1 > v2) {
                    return true;
                }
                return false;
            }
            ++i;
        }
        if (s1.length() != s2.length()) {
            if (s1.length() > s2.length()) {
                return true;
            }
            return false;
        }
        int sx = s1.compareTo(s2);
        if (sx != 0) {
            if (sx > 0) {
                return true;
            }
            return false;
        }
        return null;
    }
}

