/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.list;

import de.mn77.base.data.Lib_Random;
import de.mn77.base.data.convert.ConvSequ;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.Nil;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_List
extends A_Object {
    private ArrayList<I_Object> list;
    private final Call[] init;
    private boolean fixedLength = false;
    private boolean fixedTypes = false;

    public JMo_List() {
        this.list = new ArrayList();
        this.init = null;
    }

    public JMo_List(ArrayList<I_Object> list) {
        this.list = list;
        this.init = null;
    }

    public JMo_List(Call ... ca) {
        this.list = null;
        this.init = ca;
    }

    @Override
    public void init(CurProc cp) {
        if (this.init != null) {
            this.list = new ArrayList();
            Call[] callArray = this.init;
            int n = this.init.length;
            int n2 = 0;
            while (n2 < n) {
                Call ca = callArray[n2];
                I_Object o = ca.exec(cp, null);
                if ((o = Lib_Convert.getValue(cp, o)) instanceof JMo_Range) {
                    Result_Obj ro = ((JMo_Range)o).each(cp.copyCall(null, false), true, false);
                    JMo_List rList = (JMo_List)ro.obj;
                    this.list.addAll(rList.list);
                } else {
                    this.list.add(o);
                }
                ++n2;
            }
        }
        if (this.list.size() == 1 && this.list.get(0) instanceof JMo_Range) {
            Result_Obj ro = ((JMo_Range)this.list.get(0)).toCounter(cp).each(cp, true, false);
            this.list = ((JMo_List)ro.obj).list;
        }
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "+": 
            case "add": {
                return JMo_List.stdResult(this.add(cp));
            }
            case "-": 
            case "sub": {
                return JMo_List.stdResult(this.removePos(cp));
            }
            case "remove": 
            case "--": 
            case "dec": {
                return JMo_List.stdResult(this.removeItems(cp));
            }
            case "insert": {
                return JMo_List.stdResult(this.insert(cp));
            }
            case "concat": 
            case "++": {
                return JMo_List.stdResult(this.concat(cp));
            }
            case "sort": {
                return JMo_List.stdResult(this.sort(cp));
            }
            case "shuffle": {
                return JMo_List.stdResult(this.shuffle(cp));
            }
            case "reverse": {
                return JMo_List.stdResult(this.reverse(cp));
            }
            case "uniq": {
                return JMo_List.stdResult(this.uniq(cp));
            }
            case "copy": {
                return JMo_List.stdResult(this.copy(cp));
            }
            case "first": {
                return JMo_List.stdResult(this.first(cp));
            }
            case "last": {
                return JMo_List.stdResult(this.last(cp));
            }
            case "length": 
            case "len": 
            case "size": {
                return JMo_List.stdResult(this.size(cp));
            }
            case "get": {
                return JMo_List.stdResult(this.get(cp));
            }
            case "set": {
                return JMo_List.stdResult(this.set(cp));
            }
            case "only": {
                return JMo_List.stdResult(this.only(cp));
            }
            case "filter": {
                return JMo_List.stdResult(this.filter(cp));
            }
            case "has": 
            case "knows": {
                return JMo_List.stdResult(this.knows(cp));
            }
            case "each": {
                return this.each(cp);
            }
            case "isEmpty": {
                return JMo_List.stdResult(this.isEmpty(cp));
            }
            case "combine": 
            case "implode": {
                return JMo_List.stdResult(this.implode(cp));
            }
            case "min": {
                return JMo_List.stdResult(this.min(cp));
            }
            case "max": {
                return JMo_List.stdResult(this.max(cp));
            }
            case "cut": {
                return JMo_List.stdResult(this.cut(cp));
            }
            case "area": {
                return JMo_List.stdResult(this.area(cp));
            }
            case "to": {
                return JMo_List.stdResult(this.to(cp));
            }
            case "left": {
                return JMo_List.stdResult(this.left(cp));
            }
            case "right": {
                return JMo_List.stdResult(this.right(cp));
            }
            case "from": {
                return JMo_List.stdResult(this.from(cp));
            }
            case "fixLength": {
                this.fixedLength = true;
                return JMo_List.stdResult(this);
            }
            case "fixTypes": {
                this.fixedTypes = true;
                return JMo_List.stdResult(this);
            }
        }
        return null;
    }

    @Override
    public Result_Obj autoBlockFunction(CurProc cp) {
        return this.each(cp);
    }

    @Override
    public void describe(CurProc cp, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cp));
    }

    public ArrayList<I_Object> getInternalObject() {
        return this.list;
    }

    public void internalAdd(I_Object o) {
        if (this.fixedLength) {
            Err.forbidden(o);
        }
        this.list.add(o);
    }

    public I_Object knows(CurProc cp) {
        I_Object o = cp.pars(this, I_Object.class)[0];
        for (I_Object lo : this.list) {
            if (lo.compareTo(o) != 0) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    public I_Object size(CurProc cp) {
        cp.pars();
        return new Int(this.list.size());
    }

    @Override
    public String toDebug(CurProc cp) {
        return "List(" + this.toString() + ")";
    }

    @Override
    public String toString() {
        String s = this.list == null ? "null" : ConvSequ.toText(",", this.list);
        return "[" + s + "]";
    }

    private JMo_List add(CurProc cp) {
        I_Object[] oa = cp.parsFlex(this, 1, Integer.MAX_VALUE, false);
        this.iFixed(cp);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.list.add(o);
            ++n2;
        }
        return this;
    }

    private JMo_List insert(CurProc cp) {
        I_Object[] oa = cp.pars(this, Int.class, null);
        this.iFixed(cp);
        int pos = Lib_Convert.getIntValue(cp, oa[1]);
        this.list.add(pos - 1, oa[1]);
        return this;
    }

    private I_Object area(CurProc cp) {
        I_Object[] oa = cp.pars(this, Int.class, Int.class);
        int start = ((Int)oa[0]).gValue();
        int end = ((Int)oa[1]).gValue();
        int size = this.list.size();
        Lib_Error.ifNotBetween(cp, 1, Math.min(start, size), start);
        Lib_Error.ifNotBetween(cp, Math.max(1, start), size, end);
        return this.iCutCopy(start, Math.min(this.list.size(), end));
    }

    private JMo_List concat(CurProc cp) {
        JMo_List list2 = (JMo_List)cp.pars(this, JMo_List.class)[0];
        this.iFixed(cp);
        this.list.addAll(list2.getInternalObject());
        return this;
    }

    private JMo_List copy(CurProc cp) {
        cp.pars();
        ArrayList copy = (ArrayList)this.list.clone();
        return new JMo_List(copy);
    }

    private I_Object cut(CurProc cp) {
        I_Object[] oa = cp.pars(this, Int.class, Int.class);
        int start = ((Int)oa[0]).gValue();
        int len = ((Int)oa[1]).gValue();
        Lib_Error.ifNotBetween(cp, 1, this.list.size(), start);
        Lib_Error.ifTooLow(cp, 0, len);
        return this.iCutCopy(start, Math.min(this.list.size(), start + len - 1));
    }

    private Result_Obj each(CurProc cp) {
        boolean varlet;
        I_Object[] pars = cp.parsFlex(this, 0, 1, true);
        boolean bl = varlet = pars.length == 1;
        if (varlet) {
            cp.parType(pars[0], (Class<?>)VarLet.class);
        }
        Call stream = cp.getStream();
        Block block = cp.getCallBlock();
        if (stream == null && block == null) {
            throw new ExecError(cp, "No Stream or Block for 'each'", null);
        }
        I_Object res = this;
        block5: for (I_Object it : this.list) {
            if (varlet) {
                Var o = ((VarLet)pars[0]).getVar();
                o.set(cp, cp, it);
            }
            if (block != null) {
                try {
                    res = block.exec(cp, it);
                }
                catch (ReturnException e) {
                    Return temp = e.get();
                    switch (temp.getLevel()) {
                        case CONTINUE: {
                            continue block5;
                        }
                        default: {
                            return temp.getLoopResult();
                        }
                    }
                }
            }
            if (stream == null || block != null) continue;
            res = stream.exec(cp, it);
        }
        if (stream != null && block != null) {
            res = stream.exec(cp, this.list.get(this.list.size() - 1));
        }
        return new Result_Obj(res, true);
    }

    private JMo_List filter(CurProc cp) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            Call c = new Call(cp.getSurrBlock(), null, cp.getMethod(), cp.call.getInternPars(), cp.getDebugInfo());
            Bool ok = (Bool)cp.copyCall(c, false).parsEach(this, test, Bool.class)[0];
            if (ok.gValue().booleanValue()) {
                result.add(test);
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private I_Object first(CurProc cp) {
        cp.pars();
        return this.list.size() == 0 ? Nil.NIL : this.list.get(0);
    }

    private I_Object from(CurProc cp) {
        I_Object o = cp.pars(this, Int.class)[0];
        int par = ((Int)o).gValue();
        int size = this.list.size();
        Lib_Error.ifNotBetween(cp, 1, size, par);
        return this.iCutCopy(par, size);
    }

    private I_Object get(CurProc cp) {
        I_Object[] oa = cp.parsFlex(this, 1, Integer.MAX_VALUE, false);
        if (oa.length == 1) {
            Int oi = (Int)cp.parType(oa[0], (Class<?>)Int.class);
            int i = oi.gValue();
            if (i < 1 || i > this.list.size()) {
                throw new ExecError(cp, "Index out of bounds", "Size = " + this.list.size() + ", can't get element: " + i);
            }
            return this.list.get(i - 1);
        }
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            Int oi = (Int)cp.parType(o, (Class<?>)Int.class);
            int i = oi.gValue();
            if (i < 1 || i > this.list.size()) {
                throw new ExecError(cp, "Index out of bounds", "Size = " + this.list.size() + ", can't get element: " + i);
            }
            I_Object g = this.list.get(i - 1);
            result.add(g);
            ++n2;
        }
        return new JMo_List(result);
    }

    private Str implode(CurProc cp) {
        I_Object[] pars = cp.parsFlex(this, 0, 1, false);
        if (pars.length == 0) {
            StringBuilder sb = new StringBuilder();
            for (I_Object o : this.list) {
                sb.append(o.toString());
            }
            return new Str(sb.toString());
        }
        I_Atomic atomic = (I_Atomic)cp.parType(pars[0], (Class<?>)I_Atomic.class);
        String delimiter = Lib_Convert.getStringValue(cp, atomic);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.list.size()) {
            I_Object o = this.list.get(i);
            String s = Lib_Convert.getStringValue(cp, o);
            sb.append(s);
            if (i != this.list.size() - 1) {
                sb.append(delimiter);
            }
            ++i;
        }
        return new Str(sb.toString());
    }

    private I_Object isEmpty(CurProc cp) {
        cp.pars();
        return Bool.getObject(this.list.size() == 0);
    }

    private I_Object last(CurProc cp) {
        cp.pars();
        int len = this.list.size();
        return len == 0 ? Nil.NIL : this.list.get(len - 1);
    }

    private I_Object left(CurProc cp) {
        I_Object o = cp.pars(this, Int.class)[0];
        int left = ((Int)o).gValue();
        Lib_Error.ifTooLow(cp, 0, left);
        return this.iCutCopy(1, Math.min(left, this.list.size()));
    }

    private I_Object max(CurProc cp) {
        cp.pars();
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cp, o);
            if (result_o != null && !(d > result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object min(CurProc cp) {
        cp.pars();
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cp, o);
            if (result_o != null && !(d < result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private JMo_List only(CurProc cp) {
        I_Object[] pars = cp.parsFlex(this, 1, Integer.MAX_VALUE, false);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] i_ObjectArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                String teststr;
                I_Object par = i_ObjectArray[n2];
                if (par instanceof JMo_Regex) {
                    JMo_Regex regex = (JMo_Regex)par;
                    teststr = Lib_Convert.getStringValue(cp, test);
                    if (teststr.matches(regex.toString())) {
                        result.add(test);
                    }
                } else if (par instanceof Str) {
                    String search = Lib_Convert.getStringValue(cp, par);
                    teststr = Lib_Convert.getStringValue(cp, test);
                    if (teststr.equals(search)) {
                        result.add(test);
                    }
                } else if (test.compareTo(par) == 0) {
                    result.add(test);
                }
                ++n2;
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private JMo_List removeItems(CurProc cp) {
        I_Object[] oa = cp.parsFlex(this, 1, Integer.MAX_VALUE, false);
        this.iFixed(cp);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.list.get(i).equals(o)) {
                    this.list.remove(i);
                }
                --i;
            }
            ++n2;
        }
        return this;
    }

    private JMo_List removePos(CurProc cp) {
        Int o = (Int)cp.pars(this, Int.class)[0];
        this.iFixed(cp);
        int oi = Lib_Convert.getIntValue(cp, o) + 1;
        if (oi < 1 || oi < this.list.size()) {
            throw new ExecError(cp, "Out of borders", "Got: " + oi + " Have only: 1-" + this.list.size());
        }
        this.list.remove(oi + 1);
        return this;
    }

    private JMo_List reverse(CurProc cp) {
        cp.pars();
        ArrayList<I_Object> dest = new ArrayList<I_Object>();
        for (I_Object o : this.list) {
            dest.add(0, o);
        }
        this.list = dest;
        return this;
    }

    private I_Object right(CurProc cp) {
        I_Object o = cp.pars(this, Int.class)[0];
        int par = ((Int)o).gValue();
        Lib_Error.ifTooLow(cp, 0, par);
        return this.iCutCopy(Math.max(1, this.list.size() - par + 1), this.list.size());
    }

    private I_Object set(CurProc cp) {
        I_Object[] oa = cp.pars(this, Int.class, null);
        int i = Lib_Convert.getIntValue(cp, oa[0]);
        I_Object o = oa[1];
        if (this.fixedTypes) {
            Class<?> t = o.getClass();
            I_Object curo = this.list.get(i);
            Class<?> curt = curo.getClass();
            if (t != Nil.class && !curt.isAssignableFrom(t)) {
                throw new ExecError(cp, "Wrong Type for List-Position!", "(" + Lib_Convert.typeName(curt, curo) + ") <-- (" + Lib_Convert.typeName(t, o) + ") " + o);
            }
        }
        this.list.set(i - 1, o);
        return this;
    }

    private JMo_List shuffle(CurProc cp) {
        cp.pars();
        int[] rnd = Lib_Random.getIntArraySet(0, this.list.size() - 1);
        ArrayList<I_Object> dest = new ArrayList<I_Object>();
        int[] nArray = rnd;
        int n = rnd.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            dest.add(this.list.get(i));
            ++n2;
        }
        this.list = dest;
        return this;
    }

    private JMo_List sort(CurProc cp) {
        cp.pars();
        this.list.sort(null);
        return this;
    }

    private I_Object to(CurProc cp) {
        I_Object o = cp.pars(this, Int.class)[0];
        int par = ((Int)o).gValue();
        Lib_Error.ifNotBetween(cp, 1, this.list.size(), par);
        return this.iCutCopy(1, par);
    }

    private JMo_List uniq(CurProc cp) {
        cp.pars();
        ArrayList<I_Object> copy = this.list;
        int p = 0;
        while (p < copy.size() - 1) {
            I_Object search = copy.get(p);
            int q = copy.size() - 1;
            while (q > p) {
                if (copy.get(q).equals(search)) {
                    copy.remove(q);
                }
                --q;
            }
            ++p;
        }
        return new JMo_List(copy);
    }

    private JMo_List iCutCopy(int start, int end) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int i = start - 1;
        while (i < end) {
            result.add(this.list.get(i));
            ++i;
        }
        return new JMo_List(result);
    }

    private void iFixed(CurProc cp) {
        if (this.fixedLength) {
            throw new ExecError(cp, "Can't change size of fixed List", "Adding/Removing elements is not allowed!");
        }
    }
}

