/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.form.FormText;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;

public class Int
extends A_Number
implements I_Integer {
    private final int value;

    public Int(int val) {
        this.value = val;
    }

    @Override
    public Result_Obj call4(CurProc cp, String method) {
        switch (method) {
            case "to": {
                return Int.stdResult(this.range(cp));
            }
            case "toHex": {
                return Int.stdResult(this.toHex(cp));
            }
            case "timesUp": 
            case "times": {
                return this.times(cp, false);
            }
            case "timesDown": {
                return this.times(cp, true);
            }
            case "isEven": {
                return Int.stdResult(this.isEven(cp));
            }
            case "isOdd": {
                return Int.stdResult(this.isOdd(cp));
            }
            case "isBetween": {
                return Int.stdResult(this.isBetween(cp));
            }
            case "divisible": {
                return Int.stdResult(this.divisible(cp));
            }
        }
        return null;
    }

    @Override
    public int compareTo(I_Object o) {
        if (o instanceof Int) {
            return new Integer(this.value).compareTo(((Int)o).gValue());
        }
        return super.compareTo(o);
    }

    @Override
    public I_Atomic convertTo(CurProc cp, ATOMIC to) {
        return Lib_AtomConv.convert(cp, ATOMIC.INT, to, this, this.gValue());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Int && ((Int)obj).gValue() == this.value;
    }

    @Override
    public Integer gValue() {
        return this.value;
    }

    @Override
    public String toDebug(CurProc cp) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CurProc cp, COMPARE m) {
        I_Object o = cp.parsExt(this, new Class[][]{{Bool.class, Char.class, Int.class, Dec.class}})[0];
        int par = Lib_Convert.getIntValue(cp, o);
        if (m == COMPARE.G) {
            return Bool.getObject(this.value > par);
        }
        if (m == COMPARE.L) {
            return Bool.getObject(this.value < par);
        }
        if (m == COMPARE.GE) {
            return Bool.getObject(this.value >= par);
        }
        if (m == COMPARE.LE) {
            return Bool.getObject(this.value <= par);
        }
        if (m == COMPARE.E) {
            return Bool.getObject(this.value == par);
        }
        if (m == COMPARE.NE) {
            return Bool.getObject(this.value != par);
        }
        throw Err.todo(new Object[]{cp, m});
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP0 op) {
        switch (op) {
            case INC: {
                return new Int(this.value + 1);
            }
            case DEC: {
                return new Int(this.value - 1);
            }
            case NEG: {
                return new Int(~this.value);
            }
            case ABS: {
                return new Int(Math.abs(this.value));
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op));
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP01 op, I_Object[] pars) {
        if (pars.length == 0) {
            switch (op) {
                case POW: {
                    return new Int(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
                case SQRR: {
                    return new Int((int)Math.round(Math.sqrt(this.value)));
                }
            }
            throw Err.invalid(new Object[]{cp, op, pars});
        }
        A_Number par = (A_Number)cp.parType(pars[0], (Class<?>)A_Number.class);
        if (op == A_Number.NOP01.POW && par instanceof Int) {
            int pari = ((Int)par).gValue();
            return new Int((int)Math.round(Math.pow(this.value, pari)));
        }
        double pard = Lib_Convert.getDoubleValue(cp, par);
        switch (op) {
            case POW: {
                return new Dec(Math.pow(this.value, pard));
            }
            case SQR: {
                return new Dec(Math.exp(Math.log(this.value) / pard));
            }
            case SQRR: {
                return new Int((int)Math.round(Math.exp(Math.log(this.value) / pard)));
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + pard);
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP1 op, A_Number paro) {
        int val = this.value;
        if (paro instanceof Int) {
            int par = Lib_Convert.getIntValue(cp, paro);
            switch (op) {
                case ADD: {
                    return new Int(this.value + par);
                }
                case SUB: {
                    return new Int(this.value - par);
                }
                case MUL: {
                    return new Int(this.value * par);
                }
                case DIV: {
                    if (par == 0) {
                        throw new ExecError(cp, "Division by zero", this.value + "/" + par);
                    }
                    return new Dec((double)this.value / (double)par);
                }
                case DIVR: {
                    if ((double)par == 0.0) {
                        throw new ExecError(cp, "Division by zero", this.value + "/" + par);
                    }
                    return new Int((int)Math.round((double)this.value / (double)par));
                }
                case MOD: {
                    return new Int(this.value % par);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(par));
                }
                case LOGR: {
                    return new Int((int)Math.round(Math.log(this.value) / Math.log(par)));
                }
                case AND: {
                    return new Int(this.value & par);
                }
                case OR: {
                    return new Int(this.value | par);
                }
                case XOR: {
                    return new Int(this.value ^ par);
                }
                case SHL: {
                    return new Int(this.value << par);
                }
                case SHR: {
                    return new Int(this.value >> par);
                }
            }
        } else {
            double par = Lib_Convert.getDoubleValue(cp, paro);
            switch (op) {
                case ADD: {
                    return new Dec((double)val + par);
                }
                case SUB: {
                    return new Dec((double)val - par);
                }
                case MUL: {
                    return new Dec((double)val * par);
                }
                case DIV: {
                    if (par == 0.0) {
                        throw new ExecError(cp, "Division by zero", val + "/" + par);
                    }
                    return new Dec((double)val / par);
                }
                case DIVR: {
                    if (par == 0.0) {
                        throw new ExecError(cp, "Division by zero", val + "/" + par);
                    }
                    return new Int((int)Math.round((double)val / par));
                }
                case MOD: {
                    return new Dec((double)val % par);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(par));
                }
                case LOGR: {
                    return new Int((int)Math.round(Math.log(this.value) / Math.log(par)));
                }
                case AND: {
                    return new Dec(Double.longBitsToDouble((long)this.value & Double.doubleToRawLongBits(par)));
                }
                case OR: {
                    return new Dec(Double.longBitsToDouble((long)this.value | Double.doubleToRawLongBits(par)));
                }
                case XOR: {
                    return new Dec(Double.longBitsToDouble((long)this.value ^ Double.doubleToRawLongBits(par)));
                }
                case SHL: {
                    return new Dec(Double.longBitsToDouble(this.value << (int)Double.doubleToRawLongBits(par)));
                }
                case SHR: {
                    return new Dec(Double.longBitsToDouble(this.value >> (int)Double.doubleToRawLongBits(par)));
                }
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + paro.getClass().getSimpleName());
    }

    @Override
    protected I_Atomic number_opStr(CurProc cp, A_Number.NOP1 op, A_Atomic p) {
        int val = this.value;
        if (op == A_Number.NOP1.ADD) {
            if (p instanceof Str) {
                return new Str(String.valueOf(val) + ((Str)p).gValue());
            }
            if (p instanceof Char) {
                return new Char((char)(val + ((Char)p).gValue().charValue()));
            }
        }
        if (op == A_Number.NOP1.MUL) {
            if (p instanceof Str) {
                String s = FormText.sequence(((Str)p).gValue(), (long)this.value);
                return new Str(s);
            }
            if (p instanceof Char) {
                String s = FormText.sequence(((Char)p).gValue().charValue(), (long)this.value);
                return new Str(s);
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + p.getClass().getSimpleName());
    }

    private JMo_List divisible(CurProc cp) {
        cp.pars();
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        int i = Math.abs(this.value);
        int fi = 1;
        while (fi <= i / 2) {
            if ((double)i / (double)fi == (double)(i / fi)) {
                list.add(new Int(fi));
            }
            ++fi;
        }
        if (i != 0) {
            list.add(new Int(i));
        }
        return new JMo_List(list);
    }

    private Bool isBetween(CurProc cp) {
        I_Object[] oa = cp.pars(this, Int.class, Int.class);
        int i1 = ((Int)oa[0]).gValue();
        int i2 = ((Int)oa[1]).gValue();
        return Bool.getObject(this.value >= i1 && this.value <= i2);
    }

    private Bool isEven(CurProc cp) {
        cp.pars();
        return Bool.getObject(this.gValue() % 2 == 0);
    }

    private Bool isOdd(CurProc cp) {
        cp.pars();
        return Bool.getObject(this.gValue() % 2 != 0);
    }

    private JMo_Range range(CurProc cp) {
        Int to = (Int)cp.pars(this, Int.class)[0];
        return new JMo_Range(new Call(cp.getSurrBlock(), this, cp.getDebugInfo()), new Call(cp.getSurrBlock(), to, cp.getDebugInfo()));
    }

    private Result_Obj times(CurProc cp, boolean reverse) {
        I_Object[] pars = cp.parsFlex(this, 0, 1, true);
        Call stream = cp.getStream();
        Block block = cp.getCallBlock();
        if (pars.length == 0 && stream == null && block == null) {
            throw new ExecError(cp, "Wrong call", "No Parameter, no Stream, no Block, for times ... what to do?");
        }
        boolean varlet = pars.length == 1 && pars[0] instanceof VarLet;
        I_Object res = this;
        if (reverse) {
            int i = this.value;
            while (i >= 1) {
                block21: {
                    I_Object it;
                    I_Object i_Object = it = pars.length == 0 || varlet ? new Int(i) : pars[0];
                    if (varlet) {
                        Var o = ((VarLet)pars[0]).getVar();
                        o.set(cp, cp, it);
                    }
                    if (block != null) {
                        try {
                            res = block.exec(cp, it);
                        }
                        catch (ReturnException e) {
                            Return temp = e.get();
                            switch (temp.getLevel()) {
                                case CONTINUE: {
                                    res = temp.getResult();
                                    break block21;
                                }
                                default: {
                                    return temp.getLoopResult();
                                }
                            }
                        }
                    }
                    if (stream != null) {
                        res = stream.exec(cp, it);
                    }
                }
                --i;
            }
        } else {
            int i = 1;
            while (i <= this.value) {
                block22: {
                    I_Object it;
                    I_Object i_Object = it = pars.length == 0 || varlet ? new Int(i) : pars[0];
                    if (varlet) {
                        Var o = ((VarLet)pars[0]).getVar();
                        o.set(cp, cp, it);
                    }
                    if (block != null) {
                        try {
                            res = block.exec(cp, it);
                        }
                        catch (ReturnException e) {
                            Return temp = e.get();
                            switch (temp.getLevel()) {
                                case CONTINUE: {
                                    res = temp.getResult();
                                    break block22;
                                }
                                default: {
                                    return temp.getLoopResult();
                                }
                            }
                        }
                    }
                    if (stream != null) {
                        res = stream.exec(cp, it);
                    }
                }
                ++i;
            }
        }
        return new Result_Obj(res, true);
    }

    private I_Object toHex(CurProc cp) {
        cp.pars();
        String s = Integer.toHexString(this.value);
        return new Str(s);
    }
}

