/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version;

import de.mn77.base.data.group.Group3;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.version.A_VersionDataExt;
import de.mn77.base.version.I_VersionData;
import de.mn77.base.version.VERSIONTYPE;
import de.mn77.base.version.VersionFormatter;

public class VersionDataStd
extends A_VersionDataExt {
    private Integer minor;

    public static I_VersionData fromOld(String[] sa) {
        MDateTime time;
        Long build;
        Integer fixnr;
        Integer major = Integer.parseInt(sa[0]);
        Integer minor = Integer.parseInt(sa[1]);
        VERSIONTYPE art = VERSIONTYPE.get(sa[2].charAt(0));
        if (sa.length == 7) {
            fixnr = 1;
            build = Long.parseLong(sa[4]);
            time = new MDateTime(String.valueOf(sa[5]) + " " + sa[6]);
        } else if (sa.length == 8) {
            fixnr = Integer.parseInt(sa[4]);
            build = Long.parseLong(sa[5]);
            time = new MDateTime(String.valueOf(sa[6]) + " " + sa[7]);
        } else {
            throw Err.invalid(sa.length, sa);
        }
        return new VersionDataStd(major, minor, art, fixnr, build, time);
    }

    public VersionDataStd(int major, int minor, VERSIONTYPE art, int fixnr) {
        super(major, art, fixnr);
        this.minor = minor;
    }

    public VersionDataStd(int major, int minor, VERSIONTYPE art, int fixnr, Long build, I_DateTime zeit) {
        this(major, minor, art, fixnr);
        this.update(build, zeit);
        throw Err.todo("!!! Testen !!!");
    }

    public VersionDataStd(I_DateTime time, Long build, String[] sa) {
        super(time, build, sa);
        this.minor = Integer.parseInt(sa[1]);
    }

    protected Integer getMinor() {
        return this.minor;
    }

    @Override
    public String toString() {
        return this.iToString(true);
    }

    public String toString_BuildDate() {
        return this.getBuild() + " - " + this.getTime().getDate();
    }

    public String toString_Short() {
        return this.iToString(false);
    }

    public String toString_Dots() {
        return this.getNr() + "." + this.minor + (this.getFixnr() == 0 ? "" : "." + this.getFixnr()) + " (" + this.getBuild() + ")";
    }

    @Override
    public String toFormat(String format) {
        return new VersionFormatter().format(this, format);
    }

    @Override
    public Object[] toFileData() {
        return new Object[]{this.getNr(), this.minor, Character.valueOf(this.getType().token), this.getFixnr()};
    }

    @Override
    public char getDataSign() {
        return 's';
    }

    @Override
    protected Group3<Integer, VERSIONTYPE, Integer> update(String[] sa) {
        this.minor = Integer.parseInt(sa[1]);
        return new Group3<Integer, VERSIONTYPE, Integer>(Integer.parseInt(sa[0]), VERSIONTYPE.get(sa[2].charAt(0)), Integer.parseInt(sa[3]));
    }

    private String iToString(boolean lang) {
        String result = this.getNr() + "." + this.minor;
        if (this.getType() != VERSIONTYPE.RELEASE) {
            result = String.valueOf(result) + "-" + this.getType().text + (this.getFixnr() == 0 ? "" : "." + this.getFixnr());
        }
        if (lang) {
            result = String.valueOf(result) + " (Build: " + this.getBuild() + " - " + this.getTime() + ")";
        }
        return result;
    }
}

