/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.stream;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.thread.ThreadGate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Lib_Stream {
    public static final int CONNECT_BLOCKSIZE = 1024;

    public static String readASCII(InputStream is) throws Err_FileSys {
        StringBuffer sb = new StringBuffer();
        try {
            int readed = 0;
            while (readed >= 0) {
                readed = is.read();
                if (readed < 0) {
                    is.close();
                    continue;
                }
                sb.append((char)readed);
            }
        }
        catch (IOException e) {
            throw Err.wrap(e, "Stream-Read-Error");
        }
        return sb.toString();
    }

    public static ThreadGate connect(InputStream in, OutputStream out, boolean parallel) {
        return Lib_Stream.connect(in, out, parallel, true);
    }

    public static ThreadGate connect(InputStream in, OutputStream out, boolean parallel, boolean closeTarget) {
        return Lib_Stream.connect(in, out, parallel, closeTarget, 1024);
    }

    public static ThreadGate connect(InputStream in, OutputStream out, boolean parallel, boolean closeTarget, int block) {
        ThreadGate gate = parallel ? new ThreadGate(false) : null;
        Runnable run = () -> {
            try {
                BufferedInputStream bis = new BufferedInputStream(in);
                BufferedOutputStream bos = new BufferedOutputStream(out);
                byte[] ba = new byte[block];
                int len = 0;
                while ((len = bis.read()) > -1) {
                    bos.write(len);
                    while ((len = bis.read(ba)) == block) {
                        bos.write(ba);
                    }
                    if (len <= 0) continue;
                    bos.write(ba, 0, len);
                }
                bis.close();
                if (closeTarget) {
                    bos.close();
                } else {
                    bos.flush();
                }
                if (parallel) {
                    gate.open();
                }
            }
            catch (Throwable t) {
                Err.show(t, false);
            }
        };
        if (parallel) {
            new Thread(run).start();
        } else {
            run.run();
        }
        return gate;
    }
}

